
#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
modpoly_uni_cont_sub WITH_4_ARGS(
        t_handle,         pring,
        integer_big,      pdig,
        t_poly,        apoly,
        t_poly,        unipoly
)
/*
** modpoly_uni_cont_sub : modular univariate content subroutine.
** pdig: prime integer.
** apoly: non-zero polynomial in >= 2 variables over Zpdig.
** unipoly: univariate polynomial over Zpdig.
** returns gcd( unipoly, univariate content of apoly )
*/
{
    block_declarations;
    t_poly        respoly;
    t_handle           aph;
    t_int    aterms;
    t_int    termno;
    t_poly        acoefft;
    t_poly        temp;

    respoly = m_modpoly_incref( pring, unipoly );
    aph = m_poly_poly_to_handle( apoly );
    aterms = m_poly_nterms( aph );

    acoefft = m_poly_coefft( aph, 0 );

    if (m_poly_univariate (m_poly_poly_to_handle (acoefft)))
    {
        for (termno = 0; termno < aterms; )
        {
            temp = respoly;
            respoly = poly_u_zm_gcd (pring, pdig, acoefft, temp);
            m_modpoly_delref (pring, temp);
            if (poly_deg( respoly) == 0)
            {
                break;
            }
            termno ++;
            acoefft = m_poly_coefft( aph, termno );
        }
    }
    else
    {
        for (termno = 0; termno < aterms; )
        {
            temp = respoly;
            respoly = modpoly_uni_cont_sub (pring, pdig, acoefft, temp);
            m_modpoly_delref (pring, temp);
            if (poly_deg( respoly) == 0)
            {
                break;
            }
            termno ++;
            acoefft = m_poly_coefft( aph, termno );
        }
    }

    return respoly;
}



t_poly
modpoly_uni_cont WITH_3_ARGS(
        t_handle,         pring,
        integer_big,      pdig,
        t_poly,        apoly
)
/*
** modpoly_uni_cont : modular polynomial univariate content.
** pdig : prime integer.
** apoly : polynomial in at least two variables over Zpdig.
** returns the univariate content of apoly
*/
{
    block_declarations;
    t_poly     uni;
    t_poly     respoly;
    t_handle        temp;
    t_int  varno;

    if ( apoly == 0 )
    {
        return 0;
    }
    if (poly_z_is_zero_poly (pring, apoly))
    {
        temp = m_poly_poly_to_handle (apoly);
        while (! m_poly_univariate (temp))
            temp = m_poly_poly_to_handle (m_poly_coefft (temp, 0));
        temp = m_modpoly_handle_incref (pring, temp);
        return (m_poly_handle_to_poly (temp));
    }

    varno = m_poly_least_pvar (m_poly_poly_to_handle (apoly));
    m_poly_create_empty (&temp, varno, varno, 1);
    m_poly_coefft (temp, 0) = 0;
    m_poly_expt (temp, 0) = 0;
    uni = m_poly_handle_to_poly (temp);
    respoly = modpoly_uni_cont_sub( pring, pdig, apoly, uni );
    m_modpoly_delref (pring, uni);
    return (respoly);
}


void
modpoly_uni_contpp WITH_5_ARGS(
    t_handle,       pring,
    integer_big,    pdig,
    t_poly,      apoly,
    t_poly *,    ucont,
    t_poly *,    ppart
)
/*
** modpoly_uni_contpp: modular polynomial univariate content and
** primitive part.
** pdig is a prime integer.
** apoly is a polynomial in 2 or more variables over Zpdig,
** ucont is the univariate content of apoly,
** ppart is the primitive part if aply,
** i.e. if apoly != 0 then ppart = apoly / ucont
**      if apoly == 0 then ppart = 0.
*/
{
    if (poly_z_is_zero_poly (pring, apoly))
    {
        t_handle temp;
        *ppart = m_modpoly_incref (pring, apoly);
        temp = m_poly_poly_to_handle (apoly);
        while (! m_poly_univariate (temp))
            temp = m_poly_poly_to_handle (m_poly_coefft (temp, 0));
        temp = m_modpoly_handle_incref (pring, temp);
        *ucont = m_poly_handle_to_poly (temp);
        return;
    }

    *ucont = modpoly_uni_cont( pring, pdig, apoly );
    *ppart = modpoly_uni_quot( pring, pdig, apoly, *ucont );
}

