#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"

void
mat_z_scalar_mult_sub WITH_4_ARGS(
	t_handle,		cring,
	matrix,		a_orig,
	integer_big,	b,
	matrix *, 	pc
)
/*
** *pc := b * a, a is a matrix over cring, b an element of cring.
*/
{
	register t_int		dsq;
	t_int		i;
	t_int		m;
	t_int		n;
	matrix	matc;
	matrix	a;
	Logical	respack;

	m = mat_row(a_orig);
	n = mat_col(a_orig);

	respack = mat_result_pkd( cring, *pc );
	matc = 0;
	mat_alloc_result_unpkd(respack, *pc, matc, m, n);
	a = 0;
	mat_create_unpkd( cring, a_orig, a, m, n );

	dsq = m * n;
	for (i = 1; i <= dsq; i++)
	{
		mat_entry(matc, i) = integer_mult(mat_entry(a, i), b);
	}

	mat_create_result(cring, respack, *pc, matc);
}


matrix
mat_z_scalar_mult WITH_3_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b
)
/*
** Returns b * a, a is a matrix over cring, b an element of cring.
*/
{
	matrix c = 0;
	mat_z_scalar_mult_sub(cring, a, b, &c);
	return c;
}

