#include "defs.h"
#include "ring.h"
#include "integer.e"
#include "mat.h"

void
mat_z_hnf_col_sub WITH_5_ARGS(
	t_handle,		cring,
	matrix,		a,
	matrix *,	hnf,
	matrix *,	trn,
	Logical,	req_trn
)
/*
** Calculates Column Hermite Normal Form of a and transformation matrix where
** matrices are over the integers.
** Places Column Hermite Normal Form into *hnf.
** Places transformation matrix into *trn if req_trn is TRUE.
*/
{
	block_declarations;
	Logical		hnfpack;
	Logical		trnpack;
	matrix		adash;
	matrix		hnfdash;
	matrix		trndash;
	integer_small	m;
	integer_small	n;
	integer_big	temp;
	integer_small	r;
	integer_big	hii;
	integer_big	hij;
	integer_small	i;
	integer_small	j;
	integer_small	k;
	integer_big	rat;
	integer_big	smallest;
	Logical		found;
	integer_big	halfhii;

	m = mat_row( a );
	n = mat_col( a );
	adash = hnfdash = trndash = 0;
	smallest = 0;

	hnfpack = mat_result_pkd( cring, *hnf );
	mat_alloc_result_unpkd( hnfpack, *hnf, hnfdash, m, n );

	if ( req_trn )
	{
		trnpack = mat_result_pkd( cring, *trn );
		mat_alloc_result_unpkd( trnpack, *trn, trndash, n, n );
	}

	mat_create_unpkd( cring, a, adash, m, n );


/* Step 1: Initialisation */

	mat_copy_entries( cring, adash, hnfdash );

	if ( req_trn )
	{
		mat_ring_create_id_sub( cring, trndash );
	}

	r = ( m > n ? n : m );

	for ( i=1; i<=r; ++i )
	{
/*
		if ( i < r )
*/
		{

/* Step 2: Determination of smallest element in row i */

			k = (-1);

			for ( j=i; j<=n; ++j )
			{
				if ( k == -1 )
				{
					temp = mat_elt( hnfdash, i, j );
					if ( temp != 0 )
					{
						smallest = integer_abs( temp );
						k = j;
					}
				}
				else
				{
					temp = mat_elt( hnfdash, i, j );
					if ( temp != 0 )
					{
						temp = integer_abs( temp );
						if ( integer_compare( smallest, temp ) > 0 )
						{
							integer_delref( smallest );
							smallest = temp;
							k = j;
						}
						else
						{
							integer_delref( temp );
						}
					}
				}
			}

			if ( k == -1 )
			{
				continue;
			}

/* AKS from MD via JS: */
			integer_delref( smallest );

/* Step 3: Change of columns i and k */

			if ( i != k )
			{
				mat_ring_col_swap( cring, hnfdash, i, k, 1, m );

				if ( req_trn )
				{
					mat_ring_col_swap( cring, trndash, i, k, 1, n );
				}
			}

/* Step 4: Reduction of elements h_{ij} modulo h_{ii} for j > i */

			hii = mat_elt( hnfdash, i, i );
			if ( integer_sign( hii ) > 0 )
			{
				halfhii = integer_div( hii, 2 );
			}
			else
			{
				temp = integer_add( hii, 1 );
				halfhii = integer_div( temp, 2 );
				integer_delete( &temp );
			}

			for ( j=i+1; j<=n; ++j )
			{
				hij = mat_elt( hnfdash, i, j );

				rat = integer_add( hij, halfhii );
				temp = integer_div( rat, hii );
				integer_delref( rat );
				rat = integer_negate( temp );
				integer_delref( temp );

				mat_z_col_add( cring, hnfdash, i, j, rat, 1, m );

				if ( req_trn )
				{
					mat_z_col_add( cring, trndash, i, j, rat, 1, n );
				}

				integer_delref( rat );
			}

			integer_delref( halfhii );

			for ( j=i+1; j<=n; ++j )
			{
				hij = mat_elt( hnfdash, i, j );
				if ( hij !=0 )
				{
					break;
				}
			}

			if ( j <= n )
			{
				/*
				** Return to beginning of loop without
				** incrementing i.
				*/

				--i;
				continue;
			}
		}

/* Step 5: Reduction of elements h_{ij} modulo h_{ii} for j < i */

		hii = mat_elt( hnfdash, i, i );
		if ( integer_sign( hii ) < 0 )
		{
			mat_z_col_mult( cring, hnfdash, i, -1, 1, m );
			hii = mat_elt( hnfdash, i, i );

			if ( req_trn )
			{
				mat_z_col_mult( cring, trndash, i, -1, 1, n );
			}
		}

		for ( j=1; j<i; ++j )
		{
			hij = mat_elt( hnfdash, i, j );

			temp = integer_div( hij, hii );
			rat = integer_negate( temp );
			integer_delref( temp );

			mat_z_col_add( cring, hnfdash, i, j, rat, 1, m );

			if ( req_trn )
			{
				mat_z_col_add( cring, trndash, i, j, rat, 1, n );
			}

			integer_delref( rat );
		}

/* Step 6: Increase i */

	}

	mat_create_result( cring, hnfpack, *hnf, hnfdash );

	if ( req_trn )
	{
		mat_create_result( cring, trnpack, *trn, trndash );
	}

	mat_free_unpkd( a, adash );
}

