
#include "defs.h"
#include "ring.h"
#include "mat.h"

t_handle 
mat_ring_is_one WITH_2_ARGS(
	t_handle,		cr,
	t_ring_elt,	mat
)
/* 
** Returns TRUE if mat is the one (I) of matrices over the coefficient
** ring cr.
*/
{
	integer_small	i;
	integer_small	j;
	t_int		*ptr_mat;
	integer_small	dim;
	t_handle		matp;
	Logical		res;
	integer_small	diag;

	dim = mat_col( mat );

	if ( dim != mat_row( mat ) )
	{
		error_internal( "matrix (%d * %d) not square in mat_ring_is_one\n", mat_row( mat ), mat_col( mat ) );
	}

	mat_create_unpkd( cr, mat, matp, dim, dim );
	ptr_mat = mat_elt0_ptr( matp );

	for ( i=2; i <= dim*dim; i+= (dim+1) )
	{
		if ( ! ring_is_one( cr, ptr_mat[ i-1 ] ) )
		{
			mat_free_unpkd( mat, matp );
			return FALSE;
		}
		diag = i + dim - 1;
		for ( j=i; j<=diag; j++ )
		{
			if ( ! ring_is_zero( cr, ptr_mat[ j ] ) )
			{
				mat_free_unpkd( mat, matp );
				return FALSE;
			}
		}
	}

	res = ring_is_one( cr, ptr_mat[ dim*dim ] );
	mat_free_unpkd( mat, matp );

	return res;
}

