#include "defs.h"
#include "ring.h"
#include "mat.h"

t_int 
mat_ring_det WITH_2_ARGS(
	t_handle,	ring,
	matrix,	a
)
/*
 * Calculates the determinant of a where the coefficient ring
 * is a generic ring.
 * If the ring has echelonisation it calls the echelonisation
 * function else it calls mat_ring_det_sub.
 */
{
	t_int	result = 0;

	if (ring_is_ed(ring) || ring_is_field(ring) ||
		ring_type(ring) == RING_ZM)
	{
		mat_ring_echelon(ring, a, &result, 0, 0, 0, FALSE, 0, FALSE, 1);
	}
	else
		mat_ring_det_sub(ring, a, &result);

	return result;
}
