/*  inthdl_sizes.c
*/

#include "defs.h"
#include "inthdl.e"
#include "intbig.h"


inthdl_length
inthdl_curr_size	WITH_1_ARG(
    inthdl_handle, h
)
/*
Return the number of beta-digits in the integer currently in block h (this
is zero if the integer is zero).

The number of beta-digits used by a big integer should not be of interest to
users of integer_ functions, but will help callers of the inthdl_ functions to
pre-allocate result blocks of the correct size.
*/
{
    /*
    This is a function for external callers: internally we have a macro
    which is quicker.  The macro is not made available to callers (a) to
    keep the structure of integer blocks private and (b) to make the value
    of the current size read-only to the caller.
    */

    return intbig_curr_size(h);
}


inthdl_length
inthdl_avail_size	WITH_1_ARG(
    inthdl_handle, h
)
/*
Return the number of beta-digits available in the integer block h, so that the
caller can extend it (HOW?) if necessary
*/
{
    /*
    Again, this is a security wrapper for the internal macro
    */

    return intbig_avail_size(h);
}
