#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

integer_big
integer_solve_congruence    WITH_3_ARGS(
    integer_big,    a,
    integer_big,    b,
    integer_big,    m
)
/*
 * Given general integers a, b and m, solve for x the congruence
 *  a * x = b (mod m)   0 <= x < m
 * If a solution exists, it is returned.  Otherwise, the return
 * value is -1.
 */
{
    block_declarations;

    integer_big             gcd;
    integer_big             m1;
    integer_big             m2;
    register integer_big    prod;
    register integer_big    x;

    integer_gcd_mult(a, m, &gcd, &m1, &m2);
    integer_delref( m2 );

    if (integer_compare(gcd, 1) != 0)
    {
	/*
	 * No solution
	 */

	integer_delref( gcd );
	integer_delref( m1 );

	return -1;
    }

    /*
     * m1 = a^-1 (mod m)
     */

    /* integer_delref( gcd) where gcd = 1 */

    prod = integer_mult(m1, b);
    integer_delref( m1 );

    x = integer_rem(prod, m);
    integer_delref( prod );
    return x;
}
