#include "defs.h"
#include "integer.e"

integer_small
integer_moebius_mu WITH_1_ARG(
    integer_big,    n
)
/*
** Return the value of the Moebius mu function of the general integer n.
**
** Algorithm taken from H. Riesel, Prime Numbers and Computer Methods
** for Factorization (Birkhauser, 1985)
**
** John Brownie, August, 1989
*/
{
	register t_int	k;
	register t_int	mu;
	t_handle		factors;
	t_handle		remainders;
	Logical		proof;

	if ( integer_compare( n, 1 ) == 0)
		return 1;

	proof = TRUE;	/* require probable prime factors to be proven prime */
	integer_stk_factorise(n, &factors, &remainders, 10, 1000, 1023, 10,
500, 3, 100, n, proof);
	if (remainders != 0)
	{
		facint_delete(&factors);
		integer_wdstk_delete(&remainders, sh_items( remainders ) );
		error_internal("Could not factor %d", n);
	}

	k = sh_ffld(factors, 1, 1);
	if ( k == sh_ffld(factors, 1, 2))
	{
		/*
		 * n is made up of k distinct primes, so mu is (-1)^k
		 */
		if (k % 2 == 0)
			mu = 1;
		else
			mu = -1;
	}
	else
		mu = 0;

	facint_delete(&factors);
	return mu;
}
