#include "defs.h"
#include <math.h>
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"
#include "faclst.e"
#include "faclst.h"
#include "dyn_arr.e"
#include "dyn_arr.h"
#include "prime_cert.e"
#include "prime_cert.h"
#include "debug.h"

#define	MINEXTN	2

Logical
integer_is_prime WITH_4_ARGS(
	integer_big,		num,
	prime_cert_handle,	cert,
	Logical,		wantcert,
	t_int,		trialbnd
)
/*
** input:  num - positive general integer (single or infinte-precision)
** output: true if num is prime, false otherwise.
** determines whether num is prime.
*/
{
	block_declarations;

	Logical                 maintest;
	Logical			flag;
	prime_cert_length	i;
	prime_cert_length	it;
	integer_big 		m;
	integer_big 		n;
	faclst			primeslist;
	faclst_length		faclen;
	t_int 		primeno;
	t_int 		basesno;
	integer_big		rtn;
	integer_big		rem;
	dyn_arr_handle		remainderslist;
	integer_big		rest;
	integer_big		temp;
	t_int		sgn;
	integer_big		nmin1;
	faclst			nmin1fct;
	integer_big		bound;


	/*
	 * NOTE: primeslist is not a true faclst type as the exponent
	 * field is actually used as a flag indicating whether the
	 * corresponding prime has been proven prime yet.
	 */

	/*
	 *  Deal with some trivial cases first ...
	 */

	if (integer_compare(num, 1) <= 0)
		return FALSE;
	if (integer_compare(num, 2) == 0)
	{
		prime_cert_assure_space(cert, 1, MINEXTN);
		prime_cert_prime(cert,0) = 2;		/* incref(2) */
		prime_cert_div(cert,0) = 0;
		prime_cert_base(cert,0) = 0;
		prime_cert_curr_length(cert) = 1;
		return TRUE;
	}
	if (integer_gcd(num, 30) != 1)
	{
		if(integer_compare(num, 3) == 0)
		{
			prime_cert_assure_space(cert, 1, MINEXTN);
			prime_cert_prime(cert,0) = 3;		/* incref(3) */
			prime_cert_div(cert,0) = 0;
			prime_cert_base(cert,0) = 0;
			prime_cert_curr_length(cert) = 1;
			if(trialbnd < 3 && wantcert)
			{
				prime_cert_div(cert,0) = 2;
				prime_cert_base(cert,0) = 2;
			}
			return TRUE;
		}
		else if(integer_compare(num, 5) == 0)
		{
			prime_cert_assure_space(cert, 1, MINEXTN);
			prime_cert_prime(cert,0) = 5;		/* incref(5) */
			prime_cert_div(cert,0) = 0;
			prime_cert_base(cert,0) = 0;
			prime_cert_curr_length(cert) = 1;
			if(trialbnd < 5 && wantcert)
			{
				prime_cert_div(cert,0) = 2;
				prime_cert_base(cert,0) = 2;
			}
			return TRUE;
		}
		else 
		{
			return FALSE;
		}
	}
	DEBUG_INTEGER_0("not divisible by 2, 3 or 5");
	if(v3_df[18])
		cay_print("not divisible by 2, 3 or 5\n");
	if(integer_compare(num, trialbnd)<=0)
	{
		DEBUG_INTEGER_0("n smaller than trial division bound");
		if(v3_df[18])
			cay_print("n smaller than trial division bound\n");
		if(i_trial_div(num, 1, trialbnd))
		{
			prime_cert_assure_space(cert, 1, MINEXTN);
			prime_cert_prime(cert,0) = integer_incref( num );
			prime_cert_div(cert,0) = 0;
			prime_cert_base(cert,0) = 0;
			prime_cert_curr_length(cert) = 1;
			return TRUE;
		}
		else
			return FALSE;
	}
	/*
	 *  Next we make sure that n is "probably prime"
	 * by subjecting it to basesno Miller-Rabin tests
	 */
	
	n = integer_incref(num);
	basesno =10;
START:	;
	if(i_miller_rabin(n, basesno) == -1)
	{
		integer_delref( n );
		if (!wantcert)
		{
			/*
			 * Clean out the certificate
			 */
			prime_cert_clean( cert );
		}
		return FALSE;
	}

	DEBUG_INTEGER_1("declared probably prime by miller tests, with baseno = ", basesno);
	if(v3_df[18])
		cay_print("declared probably prime by %d miller tests\n", basesno);

	maintest = TRUE;

	/*
	 * Now we "know" that n is prime -- let's prove it.
	 * If we do not want a certificate, we may use the (rigorous)
	 * proof provided by integer_is_prime in case n < 25*10^9.
	 */


	m = integer_div(n, 1000000);
	flag = integer_compare( m, 25000 );
	integer_delref( m );
	if (( flag < 0) && !wantcert)
	{
		DEBUG_INTEGER_0("the prime is less than 25*10^9");
		if(v3_df[18])
			cay_print("prime %d less than 25*10^9\n", n);
		/*
		 * Clean out the certificate
		 */
		prime_cert_clean( cert );

		flag = integer_is_prime_25E9(n);
		integer_delref( n );
		return flag;
	}

	/*
	 * If we do want a certificate or n is too big,
	 * we use Pocklington and need the factorization of
	 * the larger part of n-1.
	 */

	primeslist = faclst_alloc( 0 );

PROOF:	;
	DEBUG_INTEGER_1("Proving primality of n = ", n);
	if(v3_df[18])
		cay_print("Proving primality of n = %d\n", n);
	nmin1 = integer_subtract(n,1);
	integer_sqrt(n, &rtn, &sgn);

	integer_quot_rem(rtn, trialbnd, &temp, &rem);
	integer_delref(rtn);

	/* rem must be small as trialbnd is small, sgn is also small */

	bound = integer_add(temp, 1);
	integer_delref(temp);

	DEBUG_INTEGER_1("bound equals ", bound);
	if(v3_df[18]) cay_print("bound equals%d\n", bound);
	DEBUG_INTEGER_0("factorise n-1:  ");
	if(v3_df[18])
		cay_print("factorise n-1:  ");

	integer_lst_factorise(nmin1, &nmin1fct, &remainderslist, basesno,
		trialbnd, 1023, 10, 500, 3, 100, bound, FALSE);
/*
**	integer_factorise(nmin1, &nmin1fct, &remainderslist, basesno,
**		trialbnd, 4095, bound);
*/
	integer_delref(bound);

	if(maintest)
	{
		it = 0;
	}
	else
		it = prime_cert_curr_length(cert);

	faclen = faclst_num_prime(nmin1fct);
	prime_cert_assure_space(cert, it+faclen, MINEXTN);
	DEBUG_INTEGER_1("plen = ", faclst_num_prime(primeslist));
	DEBUG_INTEGER_1("faclen = ", faclst_num_prime(nmin1fct));

	for(i = 0; i < faclen; i++)
	{
		m = faclst_prime(nmin1fct, i);
		i_put_prime_in_factors(primeslist, m, 0);
		DEBUG_INTEGER_2("plen = , i=  ",faclst_num_prime(primeslist),i);
		prime_cert_prime(cert, it) = integer_incref(n);
		prime_cert_div(cert, it) = 0;
		prime_cert_base(cert, it) = 0;
		it++;
	}
	prime_cert_curr_length(cert) += faclen;

	DEBUG_INTEGER_1("plen = ", faclst_num_prime(primeslist));
	DEBUG_INTEGER_0("primes:");
#ifdef DEVELOP
	if (intbig_debug_flag)
		faclst_print(primeslist);
#endif
	if(v3_df[18])
	{
		cay_print("primes:\n");
		faclst_print(primeslist);
		cay_print("\n prime divisors of n-1:\n");
		faclst_print(nmin1fct);

	}

	DEBUG_INTEGER_0("remaining factors of n-1: ");
	if(v3_df[18])
		cay_print("\n remaining factors of n-1:\n");
	rest = 1;
	if (remainderslist != 0)
	{		
		if (v3_df[18])
			dyn_int_arr_print(remainderslist);
		for( i=0; i < dyn_arr_curr_length(remainderslist); i++)
		{
			temp = dyn_arr_element(remainderslist, i);  /* alias */
			bound = rest;				 /* transfer */
			rest = integer_mult(bound, temp);
			integer_delref(bound);
			DEBUG_INTEGER_1(" ", temp);
			if (v3_df[18])
				cay_print("%d ",temp);
		}
		dyn_int_arr_delete( &remainderslist );
	}
	else{if(v3_df[18]) cay_print("none\n");}
	/* else fake delete of remainderslist (==0) */

	/*
	 * Pocklington returns:
	 * true: number is prime
	 * false: number is not prime
	 */
	if(!i_pocklington_primality_test(n, nmin1, nmin1fct, rest, cert))
	{
		DEBUG_INTEGER_0("TROUBLE");
		if(v3_df[18]) cay_print("TROUBLE");
		faclst_delete( &primeslist );
		prime_cert_reduce(cert, 1);
		faclst_delete( &nmin1fct );
		integer_delref( nmin1 );
		integer_delref( rest );
		integer_delref( n );
		n = integer_incref( num );
		basesno += 15;
		goto START;
	}
	else
	{
		if(!maintest)
		{
			primeno = 0;
			while (integer_compare(
				faclst_prime(primeslist, primeno), n) != 0)
			{
				primeno+=1;
			}
			faclst_expon(primeslist, primeno) = 1;
		}
		DEBUG_INTEGER_0("ON TO NEXT PRIME\n ");
		if(v3_df[18]) cay_print("ON TO NEXT PRIME\n ");
		maintest = FALSE;
		integer_delref(rest);
		integer_delref(nmin1);
		faclst_delete(&nmin1fct);

NEXTPRIME:	;
		it = faclst_num_prime(primeslist);
		primeno = 0;
		for(i=it-1; i > 0 ; i--)
		{
			if(faclst_expon(primeslist, i) == 0)
			{
				primeno = i;
				break;
			}
		}
		if( integer_sign( primeno ) == 0)
		/* We have reached the top of the list of numbers
		 * ("primeslist") needed to prove primality of n.
		 * The number we have reached must be 2 as "primeslist"
		 * contains the factors of n-1
		 * in ascending order. 2 is prime so we are finished -
		 * primality has been proven.
		 */
		{
#ifdef DEVELOP
			if(intbig_debug_flag)
			{
				prime_cert_print( cert );
			}
#endif

			faclst_delete(&primeslist);
			integer_delref(n);
			if (!wantcert)
			{
				prime_cert_clean( cert );
			}
			else
			{
				/*
				 * Put 2 in certificate! -wieb-
				 */
				it = prime_cert_curr_length(cert);
				prime_cert_assure_space(cert, it+1, MINEXTN);
				prime_cert_prime(cert, it) = 2;
				prime_cert_div(cert, it) = 0;
				prime_cert_base(cert, it) = 0;
				prime_cert_curr_length(cert) += 1; 
			}
			return TRUE;
		}
		integer_delref( n );

		n = integer_incref(faclst_prime(primeslist, primeno)); 
		if(integer_compare(n, trialbnd) <= 0)
		{
			faclst_expon( primeslist, primeno) = 1;
			it = prime_cert_curr_length(cert);
			prime_cert_assure_space(cert, it+1, MINEXTN);
			prime_cert_prime(cert, it) = integer_incref(n);
			prime_cert_div(cert, it) = 0;
			prime_cert_base(cert, it) = 0;
			prime_cert_curr_length(cert) += 1; /* change - wb */
			goto NEXTPRIME;
		}
		m = integer_div(n, 1000000);
		flag = integer_compare( m, 25000 );
		integer_delref( m );
		if( flag < 0 && !wantcert)
		{
			DEBUG_INTEGER_1("prime less than 25*10^9, prime = ", n);			if(v3_df[18])
				cay_print("prime %d less than 25*10^9\n", n);

			if(integer_is_prime_25E9(n))
			{
				faclst_expon( primeslist, primeno) = 1;
				/*
				 * This seems not necessary
				 *  Take it out ??- wieb-
				 */
				it = prime_cert_curr_length(cert);
				prime_cert_assure_space(cert, it+1, MINEXTN);
				prime_cert_prime(cert, it) = integer_incref(n);
				prime_cert_div(cert, it) = 0;
				prime_cert_base(cert, it) = 0;
				prime_cert_curr_length(cert) += 1; 
				
				goto NEXTPRIME;
			}
			else
			{
				DEBUG_INTEGER_0("BIG TROUBLE");
				if(v3_df[18]) cay_print("BIG TROUBLE");
				faclst_delete(&primeslist);
				prime_cert_reduce(cert, 1);
				integer_delref( n );
				n = integer_incref( num );
				basesno += 15;
				goto START;
			}
		}
		goto PROOF;
	}
}
