#include "defs.h" 
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

extern integer_small small_primes[];

Logical
i_trial_div WITH_3_ARGS(
    integer_big,    n,
    integer_big,    min,
    integer_big,    max
)
/*
** Test whether n is prime by trial division between min and max
*/
{
	block_declarations;

	register integer_big	i;
	register integer_big	first;
	register integer_big	last;
	integer_big		q;
	integer_big		r;

	/*
	 * John Brownie, August 1989
	 */

	if (integer_compare(min, small_primes[ NSPRIMES-1 ]) <= 0)
	{
		for (i = 0; i < NSPRIMES ; i++)
			if (small_primes[i] >= min)
				break;
		first = i;
		if (integer_compare(max, small_primes[ NSPRIMES-1 ]) < 0)
		{
			for (i = first; i <  NSPRIMES ; i++)
				if (small_primes[i] > max)
					break;
			last = i - 1;
		}
		else
			last =  NSPRIMES-1 ;
		for (i = first; i <= last; i++)
		{
			r = integer_rem(n, small_primes[i]);
				/* r is single precision */
			if (r == 0)
			{
				if (integer_compare(n, small_primes[i]) != 0)
					return FALSE;
				else return TRUE;
			}
		}
		min = small_primes[ NSPRIMES-1 ] + 2;
	}
	if (integer_compare(max, min) < 0)
		return TRUE;
	/*
	 * Run out of small primes, with more of the range to do: use
	 * i_medium_prime_divisor to try to find another prime divisor.  If it
	 * cannot, then n is prime (as far as this test goes).
	 */

	i_medium_prime_divisor(n, min, max, &q, &r);

	integer_delref(r);
	if (q == 1)
		return TRUE;
	/*
	 * q is a (probably) prime factor
	 */
	integer_delref(q);
	return FALSE;
}
