/******************************************************************************
  vec_to_anf_elt.c
******************************************************************************/
#include "kant.h"
#include "anf.h"
#include "vector.h"

anf_elt
vec_to_anf_elt WITH_2_ARGS (
	order,		ord,
	vector,		vec
)
/******************************************************************************
 
Description:	Converts a vector to an algebraic number.
 
Calling sequence:

	alpha = vec_to_anf_elt( ord, vec )

	anf_elt		alpha		= t_handle of algebraic number	 
	order		ord		= t_handle of order
	vector		vec		= t_handle of vector
 
History:
 
	92-06-20 CO    written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		alpha;
	integer_small	i;
	integer_small	deg;

	deg = order_abs_degree( ord );

	anf_elt_alloc( alpha, deg );
	anf_elt_den( alpha ) = 1;
	for( i = 1; i <= deg; i++ )
	{
		anf_elt_coef( alpha, i ) = integer_incref( vec_entry( vec, i));
	}

	return( alpha );
}
