/******************************************************************************
  vec_ring_dot_product.c
******************************************************************************/
#include "kant.h"

t_ring_elt
vec_ring_dot_product WITH_3_ARGS (
	t_handle,	rng,
	vector,		a,
	vector,		b

)

/******************************************************************************
 
Description:	Computes the dot product of two vectors over a given ring.
 
Calling sequence:
 
	result = vec_ring_dot_product(rng,a,b);

	t_ring_elt	result	:
	t_handle	rng	: ring of the coefficients
	vector		a,b	:	
 
History:
 
	92-05-07 KW	written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i,len;
	t_ring_elt	tempa,tempb,tempc;

	len = vec_length(a);
	
	tempa = ring_mult(rng,vec_entry(a,1),vec_entry(b,1));
	for (i=2;i<=len;i++)
	{
		tempb = tempa;
		tempc = ring_mult(rng,vec_entry(a,i),vec_entry(b,i));
		tempa = ring_add(rng,tempb,tempc);
		ring_elt_delete(rng,&tempb);
		ring_elt_delete(rng,&tempc);
	}

	return tempa;
}
