/******************************************************************************
  real_zero_eps.c
******************************************************************************/
#include "kant.h"

t_logical
real_zero_eps WITH_3_ARGS(
	t_handle,	rrng,
	t_real,		alpha,
	t_real,		eps
)
/******************************************************************************
 
Description:	Compares real alpha and 0 (with error eps), returning:

		TRUE	if |alpha| <= eps
		FALSE	if |alpha| >  eps

Calling sequence:
 
	flag = real_zero_eps(rrng,a,eps);
 
      	t_handle      	rrng	= the real ring alpha refers to
	t_real	    	alpha	= t_real number      
	t_real	    	eps	= precision of the comparisation. The user
				  does not need to specify eps (eps = MEM_NH).
				  In this case the program sets up eps to a default.
	t_logical	flag	= see above
 
History:
 
	92-09-02 KW	real_dec_prec instead of real_beta_prec
	92-06-29 KW	written
 
******************************************************************************/
{
	block_declarations;

	t_logical		Bool;
	t_real		ep,tempu;

	if (eps)
	{
		ep = real_incref(eps);
	}
	else
	{
		tempu = conv_double_to_real(rrng,0.1);
		ep    = real_power(rrng,tempu,real_dec_prec(rrng)/2);
		real_delete(&tempu);
	}

	tempu = real_abs(rrng,alpha);		
	Bool = !(real_compare(rrng,tempu,ep) == 1);
	real_delete(&tempu);
	real_delete(&ep);
	return(Bool);
}
