#include "kant.h"
#include "ring.h"
#include "mat.h"
#include "real.e"
#include "mp.e"
#include "mp.h"
#include "anf.h"
#include "conv.e"
  
t_logical
mat_z_inverse_dirty WITH_5_ARGS(
	t_handle,		ring,
	matrix,		mat,
	matrix *,	invmat,
	integer_big *,	den,
	integer_small,  prec
)
/*******************************************************************************
 
mat_z_inverse_dirty.c
 
JS September 1991
Last modification: 11.10.91
 
OK, this method for inverting an integer matrix (casting it to a
real one and inverting that by Echelonization) is not the cleverest way.
 
You have to submit the decimal precision in which the comutation should
be done. The result is correct if the function returns TRUE.
 
This routine is preliminary!!
 
*******************************************************************************/
{
	block_declarations;
 
        t_handle		reals;
	matrix		matr, invmatr;
	t_real		detr;
	mp_float	detmp, temp, temp1;
	mp_base_type	base;
	mp_length	base_places;
	integer_big	ent, temp2;
	integer_small	i, j, dim, dim2, pr;
 
                       
	reals  = real_str_create(prec);
 
	pr = real_beta_prec(reals);
 
        mp_decimal(prec, &base, &base_places);
 
	dim     = mat_row(mat);
	dim2    = dim*dim;
	matr    = mat_new(dim, dim); 
	*invmat = mat_new(dim, dim); 
 
       
/*
    Casting the matrix into a real matrix.
    It is also checked whether the entries of the matrix are to large.
*/
	for (i=1; i<=dim2; ++i)
        {       
		ent =  mat_entry(mat, i);  
 
		if(!integer_is_single(ent))
		{
			temp2 = integer_abs(ent);
			if (integer_num_decimal_digits(temp2) > prec)
			{
				integer_delref(temp2);
				return FALSE;
			}
			integer_delref(temp2);		
          	}
 
		mat_entry(matr, i) = conv_int_to_real(reals, ent);
	}
  
/*
    Now inverting the matrix and computing the determinant
*/                                     
	invmatr = 0;
	mat_fld_echelon(reals, matr, &detr, 0, 0, 0, TRUE, &invmatr, TRUE, 1);
 
	if(anf_print_level>3)
	{
		printf("\nDeterminant of matrix: \n");
		real_write(reals, detr, 80);
		printf("\n");
	}	
	
/*
    Multiplication by determinant and conversion.
    The result is probably wrong if the determinant is too large,
    so we first check the determinant.

*/
 
	real_make_mp(detr, detmp);
	*den = conv_mp_to_int_round(detmp);
 
	if(!integer_is_single(*den))
	{       
		temp2 = integer_abs(*den);
		if (integer_num_decimal_digits(temp2) > prec)
		{
			integer_delref(temp2);
	        	return FALSE;
		}
		integer_delref(temp2);		
       	}
	
	for (i=1; i<=dim2; ++i)
	{
		temp1  = mp_alloc(base, base_places); 
 
		real_make_mp(mat_entry(invmatr, i), temp);
		mp_mul(temp, detmp, temp1);
		mat_entry(*invmat, i) = conv_mp_to_int_round(temp1);
 
	        mp_delete_float(temp1);
	}
		
	mat_delref(reals, &matr);
        mp_delete_float(detmp);
 
	ring_delete(&reals);
 
	return TRUE;
}
