/******************************************************************************
  mat_real_max.c
******************************************************************************/
 
#include "kant.h"
#include "real.e"
#include "mat.h"
#include "conv.e"

t_real
mat_real_max WITH_2_ARGS(
	t_handle,		R,
	matrix,		mat
)
/*******************************************************************************
 
Description:
 
	Computes the maximal entry (absolute value) of the matrix mat.
 
    
Calling sequence:
 
	max = mat_real_max(R, mat);

	t_handle		R	= field of reals
	matrix		mat	= matrix under consideration
        integer_big     max     = maximum of absolute values of entries
 
 
History:
 
	92-05-07 JS     first version
  
*******************************************************************************/
{
	block_declarations;
 
	t_real		temp0, temp1, temp2, maxi;
	integer_small	i, num;
 
	maxi = conv_int_to_real(R, 0);           
	num  = mat_row(mat) * mat_col(mat);
 
	for (i=1; i<=num; ++i)
	{
		temp0 = mat_entry(mat, i);
		temp1 = (real_sign(R, temp0) < 0)
			? real_negate(R, temp0)
			: real_incref(temp0);
		if (real_compare(R, temp1, maxi) > 0)
		{
			temp2 = maxi;
			maxi  = real_incref(temp1);
			real_delete(&temp2);
		}
		real_delete(&temp1);
	}
 
	return maxi;
}
