/******************************************************************************
  lat_elt_ideal_to_anf_elt.c
******************************************************************************/
#include "kant.h"
#include "vector.h"
#include "anf.h"
#include "lattice.h"  


anf_elt
lat_elt_ideal_to_anf_elt WITH_4_ARGS(
	lattice,	lat,
	lat_elt,	elt,
	order,		ord, 
	anf_ideal,	id

)
/******************************************************************************
 
Description:	Calculates the basis representation of an ideal element
		(which is given as lattice element) via the basis of the
		passed order.
 
Calling sequence:
 
	alpha = lat_elt_ideal_to_anf_elt(lat,elt,ord,id)

	anf_elt		alpha	= t_handle of anf_elt
	lattice		lat	= t_handle of lattice
	lat_elt		elt	= t_handle of lattice element
	order		ord	= t_handle of order
	anf_ideal	id	= t_handle of ideal
 
History:

	92-03-23 KW	linear algebra
	92-03-17 MJ	written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		beta;
	t_handle		Z;
	integer_small	deg,i;
	vector		v,w;
    
	deg = order_rel_degree(ord);    
	Z   = m_z_str_incref(structure_z);

/*
*	simple linear algebra 
*/
	v = vec_new(deg);
	for (i=1;i<=deg;i++) vec_entry(v,i) = integer_incref(lat_elt_coef(elt,i));
	w = mat_vector_col_mult(Z,anf_ideal_tran(id),v);

	anf_elt_alloc(beta, deg);
	anf_elt_den(beta) = integer_incref(anf_ideal_tran_den(id));
	for (i=1;i<=deg;i++) anf_elt_coef(beta,i) = integer_incref(vec_entry(w,i));
	vec_delete(Z,&v);
	vec_delete(Z,&w);
	ring_delete(&Z);

	return beta;
}
