
#include "kant.h"
#include "integer.e"
#include "mat.h"
#include "anf.h"


matrix
anf_rep_mat WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
anf_rep_mat.c
 
JS September 1991
Last modification: 17.09.91
 
Representation matrix of an algebraic number
Careful! This routine does not care for any denominators, it assumes that the 
denominator of alpha is one and actually computes the representation matrix
of the numerator of alpha.
The calculation is done straightforward using the multiplication table.
If the multiplication table is not known it is computed automatically.
 
History:  
                                                               
	92-05-05 JS	order_mult_assure
	91-09-30 JS	first version
 
*******************************************************************************/
{
	block_declarations;
 
	matrix		mat;
	order		ordcoef;
	integer_small	deg;
	anf_elt		accu, temp1, temp2;
	integer_small	i, j, k;

        
/*  
    Is the order equal Z?
*/
 
	if (ring_type(ord) == RING_Z) 
	{
		mat = mat_new(1,1);
		mat_elt(mat, 1, 1) = integer_incref(alpha);
		return mat;
	}
 
	deg = order_rel_degree(ord);
        ordcoef = order_coef_order(ord);
 
 
/*
   Is alpha an integer? In this case the result is a diagonal matrix.
*/
 
	if (anf_elt_is_integer(alpha))
	{
		mat = mat_ring_create_zero(ordcoef, deg);
		for (i=1; i<=deg; ++i)
			mat_elt(mat,i,i) = integer_incref(alpha);
		return mat;
	}
	     
        order_mult_assure(ord);
 
/*  
    Allocation
*/
	mat = mat_new(deg, deg);
 
 
/*
    Loop for matrix elements. The representation matrix is the scalar product
    of the coefficient vector of alpha times the array of multiplication
    matrices in the multiplication table.
*/
       	for (i=1; i<=deg; ++i)
	{
		for (j=1; j<=deg; ++j)
		{
			accu = 0;
			for (k=1; k<=deg; ++k)
			{             
				temp1 = accu;
				temp2 = anf_mult(ordcoef, anf_elt_coef(alpha,k),
				       mat_elt(order_mult_matrix(ord,k), i, j));
				accu  = anf_add(ordcoef, temp1, temp2);
				anf_elt_delete(ordcoef, &temp1);
				anf_elt_delete(ordcoef, &temp2);
			}
			mat_elt(mat, i, j) = accu;
		}
	}
 
return mat;
}
