/******************************************************************************
  anf_ideal_tran_assure_hnf_lower.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "mat.h"
#include "anf.h"

t_void
anf_ideal_tran_assure_hnf_lower WITH_2_ARGS(
	order,		ord,
	anf_ideal,	id
)
/*******************************************************************************
 
Description:
                                                    
	If a given ideal has no transition matrix in lower hnf,
	we compute this lower hnf.
	Further we try to simplify.

  
Calling sequence:
 
        anf_ideal_tran_assure_hnf_lower(ord, id);
 
        order   	ord:     	 order over which id is defined
        anf_ideal        id:    	 ideal to have transition matrix in lower hnf

 
History:
 
	92-05-20 CO     first version

*******************************************************************************/
{       
	block_declarations;
 
	t_handle		z;
	matrix		hnf;                  

 
	order_must_be_over_z(ord);


/*******  compute Z-Basis-Presentation if not given yet  *******/

	anf_ideal_z_assure(ord, id);

/*******  compute lower hnf if not given yet  *******/

	if( !anf_ideal_tran_is_lower_hnf(id) )
	{       
		hnf = mat_ring_hnf_col( order_coef_order(ord), anf_ideal_tran(id) );
		mat_delref( order_coef_order(ord), &anf_ideal_tran(id) );
		anf_ideal_tran(id) = hnf;		
		anf_ideal_tran_hnf(id) = -1;
	}          
                                               
/*******  simplify  *******/

	z = m_z_str_incref(structure_z);                 
	mat_z_simplify ( z, anf_ideal_tran(id), &anf_ideal_tran_den(id) );           
	ring_delete(&z);
}
