/******************************************************************************
  anf_ideal_power_product.c
******************************************************************************/

#include "kant.h"

anf_ideal
anf_ideal_power_product WITH_3_ARGS(
	order,		ord,
	vector,		idv,
	vector,		ev
)

/******************************************************************************
 
Description:

	Computes the power product 

	id_1^{e_1} * ... * id_1^{e_1}

	where id_1,...,id_n are ideals.
	The exponents e_1,...,e_n must be small non-negative integers.
 
Calling sequence:

	idpp = anf_ideal_power_product(ord,idv,ev)

	idpp	=	result
	ord	=	order over which the entries of idv are given
	idv	=	vector whose entries are ideals
	ev	=	vector whose entries are small non-negative ints
 
History:
 
	93-02-19 KW	written
 
******************************************************************************/
{
	block_declarations;
 
	anf_ideal	ida,ide,idu;
	integer_small	i,n;

	n = vec_length(idv);
	if (!n) error_internal("anf_ideal_power_product: No job !");

	ida = anf_ideal_power(ord,vec_entry(idv,1),vec_entry(ev,1));
	for (i=2;i<=n;i++)
	{
		if (!vec_entry(ev,i)) continue;

		ide = ida;
		idu = anf_ideal_power(ord,vec_entry(idv,i),vec_entry(ev,i));
		ida = anf_ideal_mult(ord,ida,idu);
		anf_ideal_delete(ord,&ide);
		anf_ideal_delete(ord,&idu);
	}
	return(ida);
}
