/******************************************************************************
  anf_ideal_neighbor.c
******************************************************************************/
 
#include "kant.h"

anf_elt
anf_ideal_neighbor WITH_3_ARGS(
	order,		ord,
	anf_ideal,	id,
	integer_small,	scaling_direction
)
/*******************************************************************************
                   
Description: 
 
 	Computes the neighbor of the "1" in the ideal
        id in scaling direction.
               
 
Calling sequence: 
	
	nb = anf_ideal_neighbor(ord, id, dir);
                               
	order		ord    = t_handle of the order
        anf_ideal       id     = t_handle of ideal
        integer_small   dir    = direction
        anf_elt         nb     = neighbor

  
History:

 	92-03-01 MJ 	first version
 
*******************************************************************************/
{       
	block_declarations;

        t_handle          R; 
	integer_small	i,deg,ubound,scaling_factor_int,flag1,flag2,flag3,abs2cnt,abs1cnt;
	anf_elt	  	alpha, alpha1, alpha2, beta, neighbor;

        lattice         id_lat,id_lat_lll;  
        lat_elt         lelt;
        lat_enum_env    id_env;  
                                            
        integer_small   j,r,r1,r2,n;   
        t_real          scaling_factor,scaling_factor1,temp,temp1,eins,two,kappa;  

        matrix          basis_save,trans,transi;
        vector          abs1, abs2;
        
        double          scaling_factor_double;
        
	t_handle		Z;

	Z = m_z_str_incref(structure_z);

        R     = order_reals(ord);
        eins  = ring_one(R);
	r1    = order_r1(ord);
	r2    = order_r2(ord);
	r     = order_r(ord);
        n     = order_abs_degree(ord);
        two   = conv_int_to_real(R,1);
        abs1cnt=0;
        abs2cnt=0;
        anf_ideal_lat(ord,id,&id_lat,&id_env);
        basis_save = mat_ring_copy(R,lat_basis(id_lat)); 
        lat_enum_delete(id_lat, &id_env);
        lat_delete(&id_lat);

        
        ubound=n+1;
        flag1=0; 
        flag3=0;   
        scaling_factor_int = 1;
        scaling_factor_double = 1;
        scaling_factor     = 0;
                   
        while( flag1 == 0 )
       {         

        anf_ideal_lat(ord,id,&id_lat,&id_env);


        if (scaling_factor)
        {
              real_delete(&scaling_factor);
	      real_delete(&scaling_factor1);
        }

        if ( flag3 == 0 ) 
             {           
                      scaling_factor_double = scaling_factor_double*2;
                      scaling_factor    = conv_double_to_real(R,scaling_factor_double); 
                      scaling_factor1   = real_sqrt(R, scaling_factor);

             }
        else
             {       
                     scaling_factor  = real_mult(R,vec_entry(abs1,scaling_direction),two); 
                     scaling_factor1 = real_sqrt(R, scaling_factor);  
             }
 
           i = scaling_direction;

           for(j=1;j<=n;j++)
       	   {   
                real_delete(&mat_elt(lat_basis(id_lat),i,j));
                if ( i <= r1 ) 
                {
  	            mat_elt(lat_basis(id_lat),i,j) = real_divide(R,mat_elt(basis_save,i,j),scaling_factor);
                }
                else
                {
                    real_delete(&mat_elt(lat_basis(id_lat),i+r2,j));
  	            mat_elt(lat_basis(id_lat),i,j) = real_divide(R,mat_elt(basis_save,i,j),scaling_factor1);
  	            mat_elt(lat_basis(id_lat),i+r2,j) = real_divide(R,mat_elt(basis_save,i+r2,j),scaling_factor1);
                }  
           } 

/*
           for(j=1;j<=n;j++)
       	   {    
                temp = mat_elt(lat_basis(id_lat),i,j);
                if ( i <= r1 ) 
                {
  	             mat_elt(lat_basis(id_lat),i,j) = real_divide(R,temp,scaling_factor);
                }
                else
                {   
                     temp1 = mat_elt(lat_basis(id_lat),i+r2,j); 
                    real_write(R,temp);
                    real_write(R,temp1);
                    real_write(R,scaling_factor1);
  	            mat_elt(lat_basis(id_lat),i,j) = real_divide(R,temp,scaling_factor1);
  	            mat_elt(lat_basis(id_lat),i+r2,j) = real_divide(R,temp1,scaling_factor1);
                    real_delete(&temp1);
               }      
               real_delete(&temp);

    	   }       
*/

        if (anf_print_level > 3)
        {
        	printf("\nThe scaled basis:\n");
                mat_ring_write(lat_basis_ring(id_lat),lat_basis(id_lat));
        	printf("\n");
	}     
   
        id_lat_lll = lat_lll_reduce(id_lat,&trans,&transi);
        mat_delref(R,&lat_basis(id_lat));
        lat_basis(id_lat)=mat_incref(lat_basis(id_lat_lll));  
        lat_delete(&id_lat_lll);


        if (anf_print_level > 3)
        {
        	printf("\nThe scaled basis lll reduced:\n");
                mat_ring_write(lat_basis_ring(id_lat),lat_basis(id_lat));
        	printf("\n");
	}          
        lat_chol_calc(id_lat);
        lat_enum_status_set_new(id_env); 
        lat_enum_request_set_next(id_env);
       	lat_enum_ubound(id_env) = conv_int_to_real(lat_chol_ring(id_lat),ubound); 




	while (lat_enum(id_lat,id_env))  
	{      
               lelt = lat_elt_move(id_lat,lat_enum_act_coefs(id_env),trans); 
               alpha=lat_elt_ideal_to_anf_elt(id_lat, lelt, ord, id); 
               lat_elt_delete(id_lat,&lelt);

               beta = anf_elt_con(ord,alpha); 
               anf_elt_delete(ord, &alpha);
               if ( abs1cnt != 0 ) 
                      { 
                        vec_delete(R,&abs1); 
                      } 
               abs1cnt = 1 ; 
               abs1 = anf_elt_abs(ord, beta);   
               if (anf_print_level > 3)
                   {
                           printf("\nand the absolute values:");  
                           mat_ring_write(order_reals(ord),abs1);  
                   }

               flag2 = 1;   


               alpha2 = anf_elt_simplify(ord, beta);
               anf_elt_delete(ord,&beta);
 
               if (anf_elt_is_integer(alpha2))
        	{        
                  flag2 = 0;
        	}
               anf_elt_delete(ord, &alpha2);


               for(i=1;i<=r1+r2;i++)
		{       
                        if ( i == scaling_direction )  
                           {  
                              if (real_compare(R,vec_entry(abs1, i) , eins) < 1)  
                                     flag2 = 0;
                           }
                        else
                           {  
                              if (real_compare(R,vec_entry(abs1, i) , eins) > -1)  
                                     flag2 = 0;
                           }  
                        if ( flag3 == 1 ) 
                           {   
                             if (!real_compare(R,vec_entry(abs1, i), vec_entry(abs2,i)))  
                                     flag2 = 0;
                             if (real_compare(R,vec_entry(abs1, scaling_direction), 
                                                vec_entry(abs2, scaling_direction)) == 1)
                                     flag2 = 0;
                           }
		}      
/*
               printf("\n flag2 und flag3 :");
               integer_write(flag2); printf("  ");
               integer_write(flag3);
               printf("\n");
*/

                if ( flag2 == 1 )   

                   {   
                       if ( abs2cnt != 0 ) 
                             { 
                               vec_delete(R,&abs2);
                             } 
                       abs2cnt = 1;
                       abs2 = vec_incref(abs1);
  
                      if ( flag3 ==0 ) 
                          flag3 = 1;
                      else
                         anf_elt_delete(ord, &neighbor);
                      
                        lelt = lat_elt_move(id_lat,lat_enum_act_coefs(id_env),trans); 
                        neighbor = lat_elt_ideal_to_anf_elt(id_lat, lelt, ord, id); 
                        lat_elt_delete(id_lat,&lelt);
 
                      goto end_of_enum;    
                   }   
	}  
        if ( flag3 == 1 )  
           {    
               flag1 = 1; 
           } 
 
end_of_enum:
 
        mat_delref(Z,&trans);
        mat_delref(Z,&transi);
        lat_enum_delete(id_lat, &id_env);
        lat_delete(&id_lat);

       }
 
        real_delete(&eins);
        real_delete(&two);
        real_delete(&scaling_factor);
        real_delete(&scaling_factor1);
        vec_delete(R, &abs1);
        vec_delete(R, &abs2);

        mat_delref(R, &basis_save);
/*
        lat_enum_delete(id_lat, &id_env);
        lat_delete(&id_lat);
*/
 
	return neighbor;
} 


