/*******************************************************************************
  anf_elt_write.c

  This file contains :

  anf_elt_write
  anf_con_write

********************************************************************************/
#include "stdio.h"        
#include "kant.h"
#include "anf.h"

void
anf_elt_write WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:                               
 
     Prints an algebraic number in the form ( <coef>,<coef>,... / <denom> ).
     Here <coef> again can be of the form as above.
     The number is anf_elt_simplified before printed.
 
 
Calling sequence:

     anf_elt_write(ord, alpha);
 
         order     ord       : the order alpha refers to
         anf_elt   alpha     : the algebraic number to be printed
 
  
History:
	92-02-10 JS    anf_elt_simplify
	91-08-31 JS    written
 
*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg;
        order		ordcoef;
	integer_big	denom;
	integer_small	i;
        anf_elt         alpha1;
	void		anf_con_write();
 
        alpha1 = anf_elt_simplify(ord, alpha);
 
	if (anf_elt_is_integer(alpha1))
	{
		integer_write(alpha1);
                anf_elt_delete(ord, &alpha1);
		return;
	}
 
	if (anf_elt_is_con(alpha1))
	{
		anf_con_write(ord, alpha1);
                anf_elt_delete(ord, &alpha1);
		return;
	}
           
        deg = order_rel_degree(ord);
        ordcoef = order_coef_order(ord);
 
	printf("( ");
        for (i=1; i<=deg; ++i)
	{
		anf_elt_write(ordcoef, anf_elt_coef(alpha1,i));
		if(i<deg) printf(", ");
	}
 
	printf(" )");
 
	denom = anf_elt_den(alpha1);
	if(denom != 1)
	{
		printf(" / ");
		integer_write(denom);
	}
 
        anf_elt_delete(ord, &alpha1);
 
	return;
}
 

void
anf_con_write WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:                               
 
     Prints an algebraic number given by its conjugates.
 
Calling sequence:

     anf_con_write(ord, alpha);
 
         order     ord       : the order alpha refers to
         anf_elt   alpha     : the algebraic number to be printed
 
  
History:
	91-10-31 JS    written
 
 
*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg;
	integer_small	i;
	t_handle		reals;
 
        deg = order_rel_degree(ord);
	reals = order_reals(ord);
 
	printf("\n");
        for (i=1; i<=deg; ++i)
	{
		real_write(reals, anf_con(alpha, i), 80);
		printf("\n");
	}
 
	return;
}
 


