;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald TRANSPORTABLE-MACETES)


;;(define-operation (MACETE-REQUIREMENTS soi))


;;(define-operation (MACETE-MATCHER soi))
;;(define-operation (MACETE-LHS soi))
;;(define-operation (MACETE-RHS soi))
;;(define-operation (MACETE->FORMULA soi))
;;(define-operation (MACETE-REPLACEMENT-CONSTRUCTOR soi))
(define-predicate TRANSPORTABLE-MACETE?)
(define-operation (TRANSPORTABLE-MACETE-LHS soi))
(define-operation (TRANSPORTABLE-MACETE-RHS soi))
(define-operation (TRANSPORTABLE-MACETE-SOURCE-THEORY soi))

(lset *transportable-macetes* (make-table '*transportable-macetes*))

(define (RETRIEVE-TRANSPORTABLE-MACETE-FROM-FORMULA formula)
  (table-entry *transportable-macetes* formula))

(define (BUILD-TRANSPORTABLE-MACETE formula source-theory name safe?)

  (cond ((two-d-table-entry *transportable-macetes* formula source-theory)
	  =>
	 (lambda (mac) (set (macete-name mac) name) mac))
	(else
	 (receive (source target requirements bidirectional?)
	   (formula-source-target-requirements-bidirectional formula)
	   (let ((macete
		  (build-transportable-macete-internal
		   source
		   target
		   requirements
		   formula
		   source-theory
		   name
		   safe?
		   bidirectional?)))
	     (set (two-d-table-entry *transportable-macetes* formula source-theory) macete)

	     macete)))))

(define (BUILD-TRANSPORTABLE-MACETE-INTERNAL
	 source
	 target
	 requirements
	 formula
	 source-theory
	 name
	 safe?
	 bidirectional?)
  (let* ((jointly-exposed-vars
	  (if bidirectional?
	      (jointly-exposed-variables source target)
	      (exposed-variables target)))
	 
	 
	 (matcher (lambda (target-theory context expr)
		    (translation-and-substitution-match
		     source-theory
		     target-theory
		     (context-assumptions context)
		     (select-common-sub-theories
		      source-theory
		      target-theory
		      (fixed-theories-set))
		     source
		     expr
		     safe?)))

	 ;;a function which if called on  EXPR, either fails or returns 
	 ;;two values
	 ;;(a) a translation
	 ;;(b) a substitution

	 (replacement-constructor
	  (lambda (target-theory context expr) ;returns two values
	    (receive (translation subst)
	      (matcher target-theory context expr)
	      ;;fail if SUBST is fail.
	      (if (or (fail? translation)
;		      (not (translation-theory-interpretation? translation))
		      ;translation-match always returns (fail) or a theory interpretation.
		      (fail? subst))
		  (return (fail) '())
		  (let* ((translated-target (translate-expression translation target))
			 (substed (if safe?
				      (apply-substitution-fastidiously subst translated-target)
				      (apply-substitution-unsafe subst translated-target)))
			 ;;try making substitutions for target.
			 (req-substed
			  (map (lambda (req)
				 (let ((translated-req (translate-expression translation req)))
				   (apply-substitution subst translated-req)))
			       requirements)))

		    ;;try making substitutions for requirements.
		    (if (or (null? substed) (any? null? req-substed))
			(return (fail) '())
			(return substed
				(if safe?
				    (append
				     (restricted-substitution-definedness-conditions
				      subst
				      (map (lambda (var) (translate-expression translation var))
					   jointly-exposed-vars))
				     req-substed)
				    req-substed))))))))
	 (local-macete
	  (syntactic-procedure->macete
	   replacement-constructor
	   bidirectional?
	   name))
	 (sound? (and safe? (theory-theorem? source-theory formula))))
    
    (join
      (object nil
	
	((transportable-macete? soi) '#t)
	((macete-sound-in-theory? soi theory)
	 (ignore theory)
	 sound?)
	((macete-requirements soi) requirements)
	((macete->formula soi) formula)
	((macete-replacement-constructor soi) replacement-constructor)
	((macete-name soi) (macete-name local-macete))
	((transportable-macete-lhs soi) source)
	((transportable-macete-rhs soi) target)
	((transportable-macete-source-theory soi) source-theory)
	((print soi port) (format port "#{Transportable-macete ~a ~a}"
				  (object-hash soi)
				  (macete-name soi))))
	
      local-macete)))


(define (INSTALL-TRANSPORTABLE-MACETE theorem)
  (let ((the-name (if (not (null? (theorem-name theorem)))
		      (symbol-append 'tr% (theorem-name theorem))
		      '()))
	(formula (theorem-formula theorem)))
   (add-macete (build-transportable-macete
		formula
		(theorem-home-theory theorem)
		the-name
		'#t))))

(define (THEORY-INSTALL-TRANSPORTABLE-MACETE theory theorem)
  (ignore theory)
  (install-transportable-macete theorem))

(define (ADD-UNSAFE-TRANSPORTABLE-MACETE the-name formula theory)
  (add-macete (build-transportable-macete
	       formula
	       theory
	       the-name
	       '#f)))



