;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SUBSTITUTIONS-AT-VIRTUAL-OCCURRENCES)


;;a virtual path is a list of paths to the same quasi-occurrence.

(define (PATHS-TO-VIRTUAL-OCCURRENCES expr subexp depth-bound)
  (cond
   ((=0? depth-bound) nil)
   ((eq? subexp expr) (list nil))
   ((not (proper-subexpression? subexp expr))
    nil)
   (else
    (do ((components (expression-quasi-components-or-components expr) (cdr components))
	 (index 0 (1+ index))
	 (paths nil
		(append!
		 (map!
		  (lambda (path)
		    (cons index path))
		  (paths-to-virtual-occurrences (car components) subexp (-1+ depth-bound)))
		 paths)))
	((null? components)
	 paths)))))

(define (EXPAND-VIRTUAL-PATH expr path)
  (if (null? path) 
      nil
      (iterate loop ((expr expr) (path path))
	(if (null? path) (list nil)
      (let* ((qc-or-c (expression-quasi-constructor-or-constructor expr))
	     (qc-paths
	      (if (quasi-constructor? qc-or-c)
		  (quasi-constructor-paths-to-quasi-components qc-or-c)
		  '()))
	     (index (car path))
	     (incremental
	      (if (quasi-constructor? qc-or-c)
		  (nth qc-paths index)
		  (list (list index))))
	     (vpaths (loop (nth (expression-quasi-components-or-components expr) index)
			   (cdr path))))
	(apply append (map (lambda (y)
			     (map (lambda (x) (append x y)) incremental))
			   vpaths)))))))
	
	    

(define (SORTED-PATHS-TO-VIRTUAL-OCCURRENCES expr subexp depth-bound)
  (sort-paths! (paths-to-virtual-occurrences expr subexp depth-bound)))


(define (SUBSTITUTION-AT-VIRTUAL-PATH host replacement virtual-path)
  (iterate loop ((paths (expand-virtual-path host virtual-path))
		 (host host))
    (if (null? paths) 
	host
	(loop (cdr paths) (substitution-at-path host replacement (car paths))))))

(define (DEDUCTION-GRAPH-FORCE-SUBSTITUTION-AT-VIRTUAL-PATH
	 sqn replacement virtual-path)
  (let* ((assertion (sequent-node-assertion sqn))
	 (expanded-path (expand-virtual-path assertion virtual-path))
	 (graph (sequent-node-graph sqn))
	 (theory (deduction-graph-theory graph)))


    (iterate loop ((paths expanded-path)
		   (accumulated-sqns the-empty-set)
		   (sqn sqn)
		   (last-inference (fail)))
      (if (null? paths) 
	  (block (if (not (null? accumulated-sqns))
		     (let* ((assums (big-cap (map sequent-node-assumptions accumulated-sqns)))
			    (new-context
			     (build-context theory assums))
			    (new-sqn 
			     (post
			      (build-sequent
			       new-context
			       (sequent-node-assertion (car accumulated-sqns)))
			      graph)))
		       (walk
			(lambda(x)
			  (let ((formulas (set-difference (sequent-node-assumptions x) assums)))
			    (dg-primitive-inference-weakening x formulas)))
			accumulated-sqns)
		       (dg-primitive-inference-simplification new-sqn)))
		 last-inference)
	  (let ((inference
		 (deduction-graph-force-substitution-at-path
		  sqn
		  (car paths)
		  replacement)))
	    (if (fail? inference)
		
		last-inference
		(loop (cdr paths)
		      (if (succeed? inference)
			  (add-set-element (cadr (inference-node-hypotheses inference))
					   accumulated-sqns)
			  accumulated-sqns)
		      (inference-node-1st-hypothesis inference)
		      inference)))))))


(define (DEDUCTION-GRAPH-FORCE-SUBSTITUTION-AT-VIRTUAL-OCCURRENCES
	 sqn target replacement occurrences)
  (let* ((assertion (sequent-node-assertion sqn))
	 (virtual-paths
	  (sorted-paths-to-virtual-occurrences assertion target -1))
	 (len (length virtual-paths))
	 (virtual-paths-to-replace
	  (map (lambda (index)
		 (if (<= len index)
		     (imps-error "DEDUCTION-GRAPH-FORCE-SUBSTITUTION-AT-VIRTUAL-OCCURRENCES: index exceeds number of virtual occurrences of target." ))
		 (nth virtual-paths index))
	       occurrences)))
  (iterate loop ((paths virtual-paths-to-replace) (sqn sqn) (last-inference (fail)))
    (if (null? paths) 
	last-inference
	(let ((inference
	       (deduction-graph-force-substitution-at-virtual-path
		sqn
		replacement
		(car paths))))
	  (if (fail? inference)
	      (loop (cdr paths) sqn last-inference)
	      (loop (cdr paths)
		    (inference-node-1st-hypothesis inference)
		    inference)))))))


(define (DEDUCTION-GRAPH-READ-AND-FORCE-SUBSTITUTION-AT-VIRTUAL-OCCURRENCES
	 sqn target-input replacement-input occurrences)
  (let* ((sequent (sequent-node-sequent sqn)))
       (deduction-graph-force-substitution-at-virtual-occurrences
	sqn
	(sequent-read sequent target-input)
	(sequent-read sequent replacement-input)
	occurrences)))

;;;(theory-add-strategy
;;; the-kernel-theory
;;; (build-strategy
;;;  deduction-graph-read-and-force-substitution-at-virtual-occurrences
;;;  'force-substitution-at-virtual-occurrences
;;;  'force-substitution-at-occurrences-retrieval-protocol))

(build-universal-command
 deduction-graph-read-and-force-substitution-at-virtual-occurrences
 'force-substitution-at-virtual-occurrences
 (always '#t)
 'force-substitution-at-occurrences-retrieval-protocol)
