;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald EXPAND)


;;;processing for multiplying-out terms; 

(define (ESSENTIAL-MULTIPLICATIVE-ARGUMENTS processor expr)
    (iterate loop ((expr expr))
      (cond ((multiplication? processor expr)
	     (apply append (map loop (associative-arguments expr))))
	    ((and (exponentiation? processor expr)
		  (multiplication? processor (1starg expr)))
	     (map (lambda (x) (apply-operator (^r processor) x (2ndarg expr)))
		  (loop (1starg expr))))
	    (else (list expr)))))

(define (EXPAND* processor expr params);;first simplify without multiplying out
  (let
      ((pre-pre-simp
	(multiply-expression-list
	 processor
	 (map! (lambda (x)
		 (if (exponentiation? processor x)
		     (receive (base expr-list)
		       (string-out-nested-exponentiation processor x params)
		       (let ((expt (multiply-expression-list
				    (exponent-processor processor)
				    expr-list
				    params))
			     (^r (^r processor)))
			 (apply-operator ^r base expt)))
		     (algebraic-processor-simplify processor x params)))
	       (essential-multiplicative-arguments processor expr))
	 params)))
    (if (multiplication? processor pre-pre-simp)
	(let ((pre-simp 
	       (multiply-expression-list
		processor
		(map! (lambda (x)
			(if (exponentiation? processor x)
			    (expand^ processor x params)
			    x))
		      (associative-arguments pre-pre-simp))
		params)))

	  (if (multiplication? processor pre-simp) ;if still a multiplication, multiply out
	      (cross-multiply-expr-list
	       processor
	       (associative-arguments pre-simp)
	       params)
	      pre-simp))
 
	(if (exponentiation? processor pre-pre-simp)
	    (expand^ processor pre-pre-simp params)
	    pre-pre-simp))))

(define (CROSS-MULTIPLY processor expr sum-of-products )
  (if (addition? processor expr)
      (map-independently cons (associative-arguments expr) sum-of-products)
      (map (lambda (x) (cons expr x)) sum-of-products)))

(define (CROSS-MULTIPLY-EXPR-LIST processor expr-list params)
  (sum-of-products->expression
   processor
   (iterate repeat ((expr-list expr-list) (sum-prods '(())))
     (cond ((null? expr-list) sum-prods)
	   (else (cross-multiply processor (car expr-list)
				 (repeat (cdr expr-list) sum-prods)))))
   params))

;;;product is a list of expressions.  Everything should be already multiplied out so 
;;;just collecting terms should be sufficient.

(define (PRODUCT->EXPRESSION processor product params)
  (multiply-expression-list processor product params))

(define (SUM-OF-PRODUCTS->EXPRESSION processor sum-of-products params)
  (sum-expression-list
   processor
   (map (lambda (y) (product->expression processor y params)) sum-of-products)
   params))

;;;expand^ is only called if processor is commutative.

(define (EXPAND^ processor expr params)
  
  (receive (base expr-list)
    (string-out-nested-exponentiation processor expr params)
    (let ((expt (multiply-expression-list
		 (exponent-processor processor)
		 expr-list
		 params))
	  (^r (^r processor)))
      (cond ((scalar-constant-=0? (exponent-processor processor) expt)
	     (^formal processor base expt params))
	    ;;(apply-operator ^r base expt)
	    ;;deal with some easy cases first
	    ;;nothing is gotten rid of HERE, so no convergence requirement is needed.
	    ((scalar-constant-=1? (exponent-processor processor) expt)
	     base)
	    ((and (scalar-constant? (exponent-processor processor) expt)
		  (integer? (scalar-constant->numerical-object
			     (exponent-processor processor) expt))
		  (>=0? (scalar-constant->numerical-object
			 (exponent-processor processor) expt))
		  (addition? processor base))

	     (binomial-expansion processor base expt params))

	    ((multiplication? processor base)
	     (let* ((args (associative-arguments base))
		    (expd-args (map (lambda (x)
				      (apply-operator ^r x expt))
				    args)))

	       (multiply-expression-list processor expd-args)))
	    (else (^formal processor base expt params))))))
  

;returns an expression, essentially a^b simplified.

(define (BINOMIAL-EXPANSION processor base expt params)
  (enforce (lambda (x) (addition? processor x)) base) ;should always happen
  (sum-of-products-of-powers->expression
   processor
   (binomial processor (1starg base) (2ndarg base) expt)
   params))

;a,b is are expressions,
;returns a list of lists each one of the form ((expr1 num1) ... (exprn numn))
    
(define (BINOMIAL processor a b expt)
  (let ((n (scalar-constant->numerical-object (exponent-processor processor) expt)))
    (iterate iter ((i 0) (sum-prod '()))
      (if (<= i n)
	  (iter (1+ i)
		(cons 
		 (list (list (number->scalar-constant processor (combination n i))
			     (number->exponent-constant processor 1))
		       (list a (number->exponent-constant processor (- n i)))
		       (list b (number->exponent-constant processor i)))
		 sum-prod))
	  sum-prod))))

(define (SUM-OF-PRODUCTS-OF-POWERS->EXPRESSION processor sum-of-products params)
  (sum-expression-list
   processor
   (map
    (lambda (y)
      (algebraic-processor-simplify processor
       (product-of-powers->expression processor y params)
       params)) sum-of-products)
   params))

(define (PRODUCT-OF-POWERS->EXPRESSION processor product-of-powers params)
  (let ((numerical-constant-1 (number->scalar-constant processor 1)))
  (multiply-expression-list
   processor
   (map (lambda (z)  
		(cond ((scalar-constant-=0? (exponent-processor processor) (cadr z))
;;;Each z is a pair (base exponent).
;;;see justification below for absence of convergence requirement.
			   numerical-constant-1)
		      ((scalar-constant-=1? (exponent-processor processor) (cadr z))
		       (car z));this avoids generating terms x^1.
		      ((addition? processor (car z))
		       (binomial-expansion processor (car z) (cadr z) params))
		      (else (apply-operator (^r processor)
					    (car z)
					    (cadr z))))) product-of-powers)
   params)))


;;Ordinarily, there is no reason to assume a^0 is defined. However, 
;;the bit of code included here does not depend on that assumption. Notice that 
;;the binomial coefficients and exponents are constructed by the usual
;;form C(m,k) a^k*b^(m-k). If k=0, a^k is understood to be a.

(define (MAP-INDEPENDENTLY proc list1 list2)
  (let ((collect '()))
    (walk (lambda (x)
	    (walk (lambda (y) (push collect (proc x y))) list2)) list1)
    (reverse! collect)))

(define (DIVIDE-LIST the-list)
  (let ((l (quotient (length the-list) 2)))
    (iterate loop ((1sthalf '()) (2ndhalf the-list) (num 0))
      (if (>= num l) (return (reverse! 1sthalf) 2ndhalf)
	  (loop (cons (car 2ndhalf) 1sthalf) (cdr 2ndhalf) (1+ num))))))


(define (COMBINATION n m)
  (cond ((> m (/ n 2)) (combination n (- n m)))
	(else (do ((result 1 (/ (* result n1) m1))
		   (n1 n (-1+ n1))
		   (m1 1 (1+ m1)))
		  ((> m1 m) result)))))


;;;;;;algebraic expressions can be ordered in a more conventional ways. But for
;;;IMPS this has not shown itself to be very useful.
;;;;;; A polynomial is a list (((x1 a1) (x2 a2) ... (xn an)) ((y1 b1) ...))
;;;
;;;(define (PRODUCT->MONOMIAL processor product)
;;;  (map! (lambda (x)
;;;	  (if (exponentiation? processor x)
;;;	     (list (1starg x) (2ndarg x))
;;;	     (list x (number->scalar-constant (exponent-processor processor) 1))))
;;;	product))
;;;
;;;(define (EXPRESSION->POLYNOMIAL processor expr)
;;;  ;;;is called only when expr is an addition expression.
;;; (map! (lambda (x)
;;;	 (cond ((multiplication? processor x) (product->monomial processor (associative-arguments x)))
;;;	       ((exponentiation? processor x) (list (list (1starg x) (2ndarg x))))
;;;	       (else (list (list x (number->exponent-constant processor 1))))))
;;;       (map! (lambda (x) (order-algebraic-expression processor x)) (associative-arguments expr))))
;;;
;;;(define (POLYNOMIAL->EXPRESSION processor polynomial)
;;;  (form-sum-expression processor
;;;		       (map! (lambda (y) (monomial->expression processor y)) polynomial)))
;;;;;;    (if (null? polynomial) (number->scalar-constant processor 0)
;;;;;;	(apply-binary-associative-operator (+r processor)
;;;;;;	 (map (lambda (y) (monomial->expression processor y)) polynomial)))
;;;
;;;(define (MONOMIAL->EXPRESSION processor monomial)
;;;  (form-product-expression
;;;   processor
;;;   (map (lambda (z) (power->expression processor z)) monomial)))
;;;;;;  (if (null? monomial) (number->scalar-constant processor 1)
;;;;;;      (apply-binary-associative-operator
;;;;;;       (*r processor)
;;;;;;       (map (lambda (z) (power->expression processor z)) monomial)))
;;;
;;;(define (POWER->EXPRESSION processor power)
;;;  ;;power is a list (base exponent)
;;;  (if (scalar-constant-=1? (exponent-processor processor) (cadr power)) (car power)
;;;      (apply-operator (^r processor)
;;;		      (car power)
;;;		      (cadr power)))) 
;;;
;;;(define (TOTAL-WEIGHT e)
;;;  (iterate loop ((rest e) (sum 0))
;;;    (cond ((null? rest) sum)
;;;	  ((numerical-constant? (cadr (car rest)))
;;;	   (loop (cdr rest) (+ sum (representative (name (cadr (car rest)))))))
;;;	  (else '()))));;;returns nil if non-numerical exponent.
;;;
;;;(define (REMOVE-COEFFICIENT a)
;;;  (if (and (numerical-constant? (car (car a)))
;;;	   (numerical-constant? (cadr (car a))))
;;;      (cdr a)
;;;      a))
;;;
;;;(define (NUMERICAL-CONSTANT-> a b);;;This is used only for ordering expressions.
;;;  (> (representative (name a)) (representative (name b))))
;;;
;;;(define (COMPARE-EXPRESSIONS b a)
;;;  (cond ((and (numerical-constant? a) (numerical-constant? b)) (numerical-constant-> a b))
;;;	((numerical-constant? a) t)
;;;	((numerical-constant? b) nil)
;;;	((and (numerical-ground-expression? a) (not (numerical-ground-expression? b))) t)
;;;	((and (numerical-ground-expression? b) (not (numerical-ground-expression? a))) nil)
;;;	((and (formal-symbol? a) (formal-symbol? b))
;;;	 (string-less? (symbol->string (name a)) (symbol->string (name b))))
;;;	((formal-symbol? a) t)
;;;	((formal-symbol? b) nil)
;;;	(else
;;;	 (iterate compare-firstn= ((l1 (expression-components a))
;;;				   (l2 (expression-components b)))
;;;	   (cond ((null? l1) (not (null? l2)))
;;;		 ((null? l2) t)
;;;		 ((eq? (car l1) (car l2)) (compare-firstn= (cdr l1) (cdr l2)))
;;;		 (else (compare-expressions (car l1) (car l2))))))))
;;;
;;;(define (COMPARE-MONOMIAL a b)
;;;  (let* ((a (remove-coefficient a))
;;;	 (b (remove-coefficient b))
;;;	 (s1 (total-weight a))
;;;	 (s2 (total-weight b)))
;;;    (cond ((and (null? s1) (not (null? s2))) t)
;;;	  ((and (null? s2) (not (null? s1))) '())
;;;	  ((or (null? s1) (null? s2) (= s1 s2))
;;;	   (iterate compare-firstn= ((l1 a) (l2 b))
;;;	     (cond ((null? l1) (not (null? l2)))
;;;		   ((null? l2) t)
;;;		   ((equal? (car l2) (car l1));;;same power
;;;		    (compare-firstn= (cdr l1) (cdr l2)));;;compare remainder of monomial
;;;		   ((eq? (car (car l1)) (car (car l2)));;;same base
;;;		    (compare-expressions (cadr (car l2)) (cadr (car l1))));;;compare exponents
;;;		   (else 
;;;		    (compare-expressions (car (car l2)) (car (car l1)))))))
;;;	  (else (> s1 s2)))))
;;;
;;;(define (COMPARE-POWER a b)
;;;  (compare-expressions (car b) (car a)))
;;;
;;;(define (ORDER-ALGEBRAIC-EXPRESSION processor expr)
;;;  (cond ((formal-symbol? expr) expr)
;;;	((addition? processor expr)
;;;	 (polynomial->expression
;;;	  processor
;;;	  (sort (map (lambda (z) (sort z compare-power))
;;;		     (expression->polynomial processor expr))
;;;		compare-monomial)))
;;;	(else (apply (expression-constructor expr)
;;;		     (map (lambda (x) (order-algebraic-expression processor x))
;;;			  (expression-components expr))))))
;;;
;;;
;;;
