;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald (theory_inference existential-matching))

(define (paths-and-substs-unifying host target exoscopes)
  (paths-and-values-to-succeeding-virtual-occurrences
   host
   (lambda (subexpr)
     (unify-under-exoscopes (list target subexpr) exoscopes))
   -1))

(define (paths-and-substs-unifying-existential-to-macete
	 existential
	 elementary-macete
	 all-exoscopes)
  (if (existential? existential)
      (let ((exoscopes (set-difference
			all-exoscopes
			(expression-newly-bound-variables existential)))
	    (host (binding-body existential)))
	(let ((target (expression-change-free-variables
		       (elementary-macete-lhs elementary-macete)
		       all-exoscopes)))
	  (paths-and-substs-unifying host target exoscopes)))
      (return '() '())))

(define (sequent-derive-instance-from-macete sequent macete)
  (enforce elementary-macete? macete)
  (let ((context (sequent-context sequent))
	(assertion (sequent-assertion sequent)))
    (receive (paths substs)
      (paths-and-substs-unifying-existential-to-macete
       assertion
       macete
       (sequent-free-variables sequent))
      (if (null? paths)
	  '#f
	  (let ((body (binding-body assertion))
		(nbvs (expression-newly-bound-variables assertion)))
	    (iterate iter ((paths paths)
			   (substs substs))
	      (cond
	       ((null? paths)
		;;
		;; Lose here
		;; 
		'#f) 
	       ((not (subset? nbvs (subst-domain (car substs))))
		;;
		;; subst doesn't cover newly bound variables
		;;
		(iter (cdr paths) (cdr substs))) 
	       ((let ((target
		       (apply-substitution-at-path (car substs) body (car paths))))
		  (eq? target
		       (receive (val ())
			 (run-proc-with-minor-premises
			  (lambda ()
			    (apply-procedure-at-path
			     (macete-replacement-constructor macete)
			     context
			     target
			     (car paths)
			     (bidirectional-tactic? macete))))
			 val)))
		;;
		;; Some macete requirement fails in context -- look further
		;;
		(iter (cdr paths) (cdr substs)))
	       (else
		;;
		;; Succeed here
		;;
		(build-sequent
		 context
		 (apply-substitution (car substs) body))))))))))

(define (derive-instance-from-macete-strategy sqn macete)
  ((sequential-strategy-constructor
    (list
     (lambda (sqn)
       (let* ((major-premise
	       (sequent-derive-instance-from-macete (sequent-node-sequent sqn) macete))
	      (infn
	       (if major-premise
		   (dg-primitive-inference-existential-generalization
		    sqn
		    (post major-premise (sequent-node-graph sqn)))
		   (fail))))
	 (inference-node-simplify-minor-hypotheses infn)
	 infn))
     (lambda (sqn)
       (dg-primitive-inference-macete-application-with-minor-premises-at-paths
	sqn
	'(())
	macete))))
   sqn))
   

;; 
;; (build-universal-command
;;  derive-instance-from-macete-strategy
;;  'derive-instance-from-macete
;;  (always '#t)
;;  'tactic-retrieval-protocol)	 

(define (auto-instantiate-existential sqn)
  (let ((assertion (sequent-node-assertion sqn)))
    (enforce existential? assertion)
    (let ((nbvs (binding-variables assertion))
	  (conjuncts (ultimate-conjuncts (list (binding-body assertion)))))
      (let ((terms (auto-instantiate-existential-find-terms sqn nbvs conjuncts)))
	(if (succeed? terms)
	    (instantiate-existential sqn terms)
	    (fail))))))
	  
(define (auto-instantiate-existential-find-terms sqn nbvs conjuncts)
  (let ((context (sequent-node-context sqn))
	(assumptions (sequent-node-assumptions sqn)))
    (let ((substs
	   (iterate iter ((conjuncts conjuncts)
			  (substs '()))
	     (if (null? conjuncts)
		 (reverse! substs)
		 (let ((subst
			(auto-instantiate-find-subst context assumptions (car conjuncts))))
		   (if (fail? subst)
		       (iter (cdr conjuncts) substs)
		       (iter (cdr conjuncts) (cons subst substs))))))))
;;      (crawl (the-environment))
      (auto-instantiate-substs->terms substs nbvs))))
	
(define (auto-instantiate-find-subst context assumptions expr)
  (iterate iter ((assumptions assumptions))
    (if (null? assumptions)
	(fail)
	(iterate sub-iter ((conjuncts (ultimate-conjuncts (list (car assumptions)))))
	  (if (null? conjuncts)
	      (iter (cdr assumptions))
	      (let ((subst
		     (context-match context (car conjuncts)
				    expr (context-low-simplification-persistence))))
		(if (fail? subst)
		    (sub-iter (cdr conjuncts))
		    subst)))))))

(define (auto-instantiate-substs->terms substs nbvs)
  (let ((select-subst
	 (lambda (substs nbvs)
	   (iterate iter ((substs substs))
	     (cond ((null? substs) (fail))
		   ((subset? nbvs (subst-domain (car substs))) (car substs))
		   (else (iter (cdr substs)))))))
	(selectively-join-substs
	 (lambda (substs)
	   (iterate iter ((the-subst (car substs))
			  (rest (cdr substs)))
	     (cond ((subset? nbvs (subst-domain the-subst)) the-subst)
		   ((null? rest) (fail))
		   ((joinable? (car rest) the-subst)
		    (iter 
		     (join-two-substitutions (car rest) the-subst)
		     (cdr rest)))
		   (else (iter the-subst (cdr rest)))))))
	(reorder-subst
	 (lambda (subst)
	   (if (fail? subst)
	       (fail)
	       (map
		(lambda (var)
		  (substitution-find-replacement subst var))
		nbvs)))))
	   
    (reorder-subst 
     (let ((try (select-subst substs nbvs)))
       (if (succeed? try)
	   try
	   (iterate iter ((substs substs))
	     (if (null? substs)
		 (fail)
		 (let ((try (selectively-join-substs substs)))
		   (if (succeed? try)
		       try
		       (iter (cdr substs)))))))))))
	      
  
(define (auto-instantiate-universal-antecedent sqn assumption-assumption-string-or-index)
  (let ((assumption (sqn-coerce-to-assumption sqn assumption-assumption-string-or-index)))
    (enforce universal? assumption)
    (if (not (context-entails? (sequent-node-context sqn) assumption))
	(imps-error "auto-instantiate-universal-antecedent: Sqn ~S does not include ~S"
		    sqn assumption)
	(let ((nbvs (binding-variables assumption))
	      (conjuncts (map push-not (ultimate-disjuncts (list (binding-body assumption))))))
	  (let ((terms (auto-instantiate-existential-find-terms sqn nbvs conjuncts)))
	    (if (succeed? terms)
		(instantiate-universal-antecedent-once sqn assumption terms)
		(fail)))))))
	  
(build-universal-command
 auto-instantiate-universal-antecedent
 'auto-instantiate-universal-antecedent
 (always '#t)
 'single-universal-formula-retrieval-protocol)

(build-universal-command
 auto-instantiate-existential
 'auto-instantiate-existential
 (always '#t))

