;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald CALCULUS-EXERCISE)
;
;
;                             CALCULUS EXERCISE
;
;

; The following file defines a simple extension of the theory
; h-o-real-arithmetic, which provides an algebraic, axiomatic characterization
; of the derivative operator for polynomials. No epsilon/delta arguments are
; necessary.

; To do this exercise, have the "tea" process evaluate each s-expression in the
; file in the order in which they appear.  To evaluate an s-expression, position
; the cursor somewhere within the s-expression and select "evaluate def-form"
; from the "Building IMPS Objects" pane of the menu.  If you do not like
; menus or for some reason do not have them available (for example, you are working 
; from a terminal), you can also use the keystroke "C-c e."  Note that some forms 
; take a few seconds to evaluate.  
;
; If a form begins with "def-theorem" you will want to PROVE it first before
; asking IMPS to install it as a theorem.
;
; The file you are looking at (as are all others in the exercise part of the
; tutorial) is a copy of the original. Thus feel free to make additions to it as
; you see fit.
;
;
; PART I: Build the Theory
;
; The first step is to create a language consisting of the language of the 
; theory "h-o-real-arithmetic" plus a new constant "d" to serve as a derivative 
; operator.  The sort of d is "[[rr,rr],[rr,rr]]"; hence, d transforms one 
; real-valued function into another.  Since there is no distinction between 
; upper-case and lower-case, we write "d" as "D" for readability.

(def-language CALCULUS-LANGUAGE
  (embedded-language h-o-real-arithmetic)
  (constants				
   (d "[[rr,rr],[rr,rr]]")))

; The following def-theory form creates an extension of the theory 
; "h-o-real-arithmetic" in which D is axiomatized by five axioms.

(def-theory CALCULUS-THEORY
  (language calculus-language)
  (component-theories h-o-real-arithmetic)
  (axioms
   (definedness-of-differentiable-fns
     ;;
     ;; If the derivative is defined at a point,
     ;; then so is the function (at that point)
     ;; 
     "forall(x:rr,f:[rr,rr],
       #(D(f)(x))			
        implies				
       #(f(x)))")			
   (sum-rule
    ;;
    ;; If the derivatives are defined at a point, then
    ;; the derivative of the SUM (at that point)
    ;; is the SUM of the derivatives (at that point)
    ;; 
    "forall(f,g:[rr,rr],x:rr,
        #(D(f)(x)) and #(D(g)(x))
      implies
	D(lambda(x:rr,f(x)+g(x)))(x)=D(f)(x)+D(g)(x))")
   (product-rule
    ;;
    ;; If the derivatives are defined at a point, then
    ;; the derivative of the PRODUCT (at that point)
    ;; is the PRODUCT of the derivatives (at that point)
    ;; 
    "forall(f,g:[rr,rr],x:rr,
	#(D(f)(x)) and #(D(g)(x))
      implies
	D(lambda(x:rr,f(x)*g(x)))(x)=D(f)(x)*g(x)+f(x)*D(g)(x))")
   (diff-constant
    ;;
    ;; The derivative of a constant function
    ;; is the function that is constantly zero
    ;; 
    "forall(c:rr,D(lambda(x:rr,c))=lambda(z:rr,0))")
   (diff-identity
    ;;
    ;; The derivative of the identity function
    ;; is the function that is constantly one.  
    ;;
    "D(lambda(x:rr,x))=lambda(x:rr,1)")))

; The next form tells IMPS to print "D" in calligraphic font with TeX.

(def-print-syntax d
 tex
 (token " {\\cal D} ")
 (method present-tex-prefix-operator)
 (binding 160))

; To set the current theory to "calculus-theory" using the mouse, go to the
; "General" pane and click on the option "set current theory", or else evaluate
; the following form:

(set (current-theory) (name->theory 'calculus-theory))


; PART II: Prove the Homogeneity of Differentiation
;
; The homogeneity of differentiation -- the fact that we can shift a constant
; factor out past the derivative operator -- follows from the product rule. 
; We'll prove it.
;
; A word of caution:
;
; In this (and other proofs) you will need to "lambda-abstract" a term in order
; to apply the rules for differentiation.  Thus, think of "c" as
; "lambda(x:rr,c)(x)".  For the following exercise, do it directly using
; force substitution.  Below you will learn how to get IMPS to do this
; abstraction using macetes.
;
; To start the proof, go to the "Deduction Graphs" pane in the menu and click on
; "start dg".  You can also enter "M-x imps-start-deduction," where "M-x" stands 
; for "Meta-x."  IMPS will then prompt you for a formula in the minibuffer.  In 
; the minibuffer, type in the string of characters (including the double quotes)
;
;  "forall(x,c:rr,f:[rr,rr],#(D(f)(x)) implies D(lambda(x:rr,c*f(x)))(x)=c*D(f)(x))"
;
; or click the RIGHT mouse button on the formula, BETWEEN THE DOUBLE QUOTES and then press <RET>. 
;
; In order to prove the theorem you will have to do the following:
;
; 1.  Find force-substitution on the command menu.  You want to lambda abstract
;     "c" to the form "lambda(x:rr,c)(x)" at c's leftmost (0-th)
;     occurrence.  This will leave you with two subgoals: showing that the
;     result of making the substitution is true, and showing that the
;     substitution is legitimate.
; 2.  To justify the substitution, find either simplify or beta-reduce on the 
;     command menu.  The keystroke C-c s will also cause IMPS to simplify.
; 3.  Moving back to the main subgoal, look for the product rule on the macete
;     menu.  This will also add two subgoals: one in which the product rule has
;     been applied, and one requiring that the derivative of lambda(x:rr,c) be
;     defined at x.  
; 4.  To knock off the definedness requirement, find diff-constant on the macete
;     menu; then either simplify or beta-reduce (look on command menu).   
; 5.  Moving back to the main subgoal, you will again need diff-constant.
; 6.  Simplify.  Finally, you need to use definedness of differentiable
;     functions from the macete menu.
;
; After you have proved the theorem, install it by evaluating the following form:

(def-theorem HOMOGENEITY-OF-DIFF
  "forall(x,c:rr,f:[rr,rr],#(D(f)(x)) implies D(lambda(x:rr,c*f(x)))(x)=c*D(f)(x))"
  (theory calculus-theory)
  (proof 
   (
    (force-substitution "c" "lambda(x:rr,c)(x)" (0))
    (apply-macete-with-minor-premises product-rule)
    (apply-macete-with-minor-premises diff-constant)
    simplify
    (apply-macete-with-minor-premises definedness-of-differentiable-fns)
    (apply-macete-with-minor-premises diff-constant)
    beta-reduce-repeatedly

    )))


; PART III: Prove the Power Rule

; Next we will prove the power rule -- that the derivative of x^n is n*x^(n-1)
; -- using induction of n.
;
;   "forall(n:zz,2<=n implies D(lambda(x:rr,x^n))=lambda(x:rr,n*x^(n-1)))"
;
; In the formulation, we assume that 2<=n.  This is because the IMPS theory of
; the reals does not define 0^0.  As a consequence, the power rule is false for
; n=1, as D(lambda(x:rr,x^1)) is constantly 1, while lambda(x:rr,1*x^0) is
; constantly 1, except at 0, where it is undefined.  The power rule as
; formulated here is correct (in our theory of the reals, for the usual
; derivative) for n=0, but this fact cannot be proved from the purely algebraic
; properties given in the axiomatization above. 
;
; To prove the power rule, first observe that it asserts the equality of two
; functions.  By contrast, the axioms governing D talk about the values of the
; functions.  Thus, we will need to use the extensionality principle to reduce
; the assertion to the claim that the functions behave the same for all
; arguments.
;
; We will describe the proof in less detail than the previous one.
;
; 1.  Use direct inferences to break up the assertion.
; 2.  Apply extensionality.
; 3.  Induct (integer inductor).
; 4.  In the base case, replace x^2 with lambda(x:rr,x)(x)*lambda(x:rr,x)(x),
;     followed by the product rule, diff-identity, and simplification.
; 5.  In the induction step, replace x^(1+t) by
;     lambda(x:rr,x^t)(x)*lambda(x:rr,x)(x), followed by the product rule,
;     diff-identity, and simplification. 
;
; After you have proved the power rule, install it by evaluating the following form:

(def-theorem POWER-RULE
  "forall(n:zz,2<=n implies D(lambda(x:rr,x^n))=lambda(x:rr,n*x^(n-1)))"
  (theory calculus-theory)
  (proof
   (

    direct-and-antecedent-inference-strategy
    extensionality
    (induction integer-inductor ("n"))
    (force-substitution "x^2" "lambda(x:rr,x)(x)*lambda(x:rr,x)(x)" (0))
    (apply-macete-with-minor-premises product-rule)
    (apply-macete-with-minor-premises diff-identity)
    simplify
    (apply-macete-with-minor-premises diff-identity)
    simplify
    (force-substitution "x^(1+t)" "lambda(x:rr,x^t)(x)*lambda(x:rr,x)(x)" (0))
    (apply-macete-with-minor-premises product-rule)
    (apply-macete-with-minor-premises diff-identity)
    simplify
    simplify

    )))
