#!/bin/sh
# $Header: /usr/src/local/imps/src/RCS/xdg_aegis.sh,v 1.3 90/11/07 07:05:45 ramsdell Exp $

# Start xdg for Imps.  Deletes the named pipe when xdg finishes.
# The shell arguments give the command arguments for xdg.
# Output from T goes to xdg via a named pipe which is the first argument.
# Output from xdg goes to an emacs buffer.

trap 'rm -f $1; exit' 0 1 2 3 15

IMPS=${IMPS-`pwd`}

if test -d /kernel
   then PATH=$PATH:$IMPS/../bin:$IMPS/../bin/sysvr4
   else PATH=$PATH:$IMPS/../bin:$IMPS/../bin/`arch`
   fi

echo \; Command: xdg "$@" >&2

xdg "$@"

rm -f $1
