;; Copyright (c) 1990-1994 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



(provide 'imps-lucid-support)

(defconst imps-exercise-directory (concat (getenv "THEORIES") "/exercises"))

(defvar imps-mouse-call-p '())

(defun set-local-buttons-hook ()
  (local-set-key 'button3 'run-imps-mouse-hooks))

(defun run-imps-mouse-hooks (event)
  (interactive "@e")
  (funcall x-process-mouse-hook event))

(defvar x-process-mouse-hook 'x-mouse-activate-point-to-mouse)

(defun mouse-call-p-set (fn)
  (let ((imps-mouse-call-p 't))
    (cond ((commandp fn) (call-interactively fn))
	  ((symbolp fn) (funcall fn))
	  (t (eval fn)))))

(defconst *command-key-binding-alist*
  '(("simplify" . " (C-c s)")
    ("beta-reduce-repeatedly" . " (C-c b)")
    ("backchain" . " (b)")
    ("induction" . " (i)")
    ("extensionality" . " (~)")
    ("direct-and-antecedent-inference-strategy" . " (D)")
    ("direct-inference" . " (d)")
    ("force-substitution" . " (f)")
    ("raise-conditional" . " (r)")
    ("unfold-single-defined-constant" . " (u)")
    ("unfold-single-defined-constant-globally" . " (U)")
    ("unfold-defined-constants" . " (C-c U)")
    ("antecedent-inference" . " (a)")
    ("contrapose" . " (c)")
    ("weaken" . " (w)")
    ("incorporate-antecedent" . " (@)")))


(defun command-with-key-binding (command)
  (let ((key (cdr (assoc command *command-key-binding-alist*))))
    (if key (concat command key) command)))

(defun imps-proof-panes ()
  (let ((basic
	 '(["Start dg" (mouse-call-p-set 'imps-start-deduction) t]
;;
;;  ["Start another dg" (mouse-call-p-set 'imps-new-start-deduction) t]
;;  
	   ["Update dg display" (mouse-call-p-set 'dg-update-sqn-and-dg) t]
	   ["Verbosely update dg display" (mouse-call-p-set '(dg-update-sqn-and-dg t)) t]
	   ["Restart xdg" (mouse-call-p-set 'run-xdg) t])))
    
    (list (cons "DG"
		(if (eq major-mode 'sqn-mode)
		    (append '(["Display dg chunk (.)" (mouse-call-p-set 'sqn-display-dg-chunk) t]
			      ["Read and start dg" (mouse-call-p-set 'imps-read-and-start-deduction) t])
			    basic)
		  (if (eq major-mode 'dg-mode)
		      (append '(["Display sqn (.)" (mouse-call-p-set 'dg-display-sqn) t])
			      basic)
		    basic))))))

(defconst imps-fundamental-panes
  '(("IMPS-Help"
     ["IMPS manual entry"   (mouse-call-p-set 'imps-manual-entry) t]
     ["Find def-form (C-c .)" (mouse-call-p-set 'imps-find-definition) t]
     ["Check expression syntax" (mouse-call-p-set 'check-imps-syntax-of-expression) t]
;;
;; ["Tutorial" (mouse-call-p-set 'imps-tutorial-formulas) t]
;; 
     ["Exercises" (mouse-call-p-set 'imps-exercises) t]
     ["Insert proof of next theorem" (mouse-call-p-set 'locate-and-insert-proof) t]
     ["Current exercise: Next Problem" (mouse-call-p-set 'imps-exercise-next-target) t]
     ["Restart exercise in Current Buffer"
      (mouse-call-p-set 'imps-exercise-start-in-current-file) t]
     "---"
     ["Next micro exercise" (mouse-call-p-set 'imps-next-micro-exercise) t]
     ["Previous micro exercise" (mouse-call-p-set 'imps-previous-micro-exercise) t]
     ["Restart micro exercise" (mouse-call-p-set 'imps-repeat-micro-exercise) t])
    
    ("General"
     ["Set current theory" (mouse-call-p-set 'set-current-theory) t]
     ["Load section" (mouse-call-p-set 'imps-load-section) t]
     ["Load references for section" (mouse-call-p-set 'imps-load-section-references) t]
     ["Quick-load section" (mouse-call-p-set 'imps-quick-load-section) t]
     "--"
     ["Theory network status" (mouse-call-p-set 'imps-status) t]
     ["Examine theory interpretation" (mouse-call-p-set 'examine-theory-interpretation) t]
     "--"
     ["Reset dump" (mouse-call-p-set 'imps-reset-dump) t]
     "--"
     ["Interrupt IMPS" (mouse-call-p-set 'interrupt-tea-process) t]
     ["Continue IMPS"  (mouse-call-p-set 'continue-tea-process) t]
     ["Run IMPS" (mouse-call-p-set 'run-imps) t]
     ["Quit IMPS" (mouse-call-p-set 'quit-imps) t])))

(defconst scheme-mode-panes
  '(("Def-forms"
     ["Evaluate def-form (C-c e)" (mouse-call-p-set 'tea-send-definition) t]
     ["Evaluate def-form; go to tea (C-c C-e)" (mouse-call-p-set 'tea-send-definition-and-go) t]
     ["Insert def-form template" (mouse-call-p-set 'insert-template )t])
    ("Scripts"
     ["Insert proof script (C-c i)" (mouse-call-p-set 'imps-insert-current-proof) t]
     "--"
     ["Execute proof line (C-c l)" (mouse-call-p-set 'imps-assistant-execute-line) t]
     ["Execute region (C-c r)" (mouse-call-p-set 'imps-assistant-execute-region) t])))

(defconst imps-dg-panes
  '(("Extend-DG"
     ["Commands (?)" (mouse-call-p-set 'imps-x-command-menu) t]
     ["Macetes (with minor premises)"
      (mouse-call-p-set 'apply-macete-with-minor-premises-menu) t]
     "---"
     ("Annotations"
      ["Comment preceding entry"  (mouse-call-p-set 'imps-comment-latest-entry) t]
      ["Annotate" (mouse-call-p-set '(dg-apply-command "annotate" (list (current-sqn-no)))) t])
     ("Macetes"

      ["Without minor premises" (mouse-call-p-set 'apply-macete-menu) t]
      ["Locally" (mouse-call-p-set 'apply-macete-locally-menu) t]
      ["Locally and with minor-premises" (mouse-call-p-set 'apply-macete-locally-with-minor-premises-menu) t]

      )
     ["Special commands" (mouse-call-p-set 'imps-x-special-command-menu) t]

     ["Macete description (C-c ?)" (mouse-call-p-set 'imps-macete-menu )t])
    ("Nodes"
     ["First unsupported relative (F)" (mouse-call-p-set 'imps-first-unsupported-relative) t]
     ["First unsupported descendent" (mouse-call-p-set 'imps-first-unsupported-descendent) t]
     ["Sqn by number" (mouse-call-p-set 'sqn-select) t]
     ["Maximum sqn" (mouse-call-p-set 'sqn-display-max) t]
     ["Next sqn (n)" (mouse-call-p-set 'sqn-display-next) t]
     ["Previous sqn (p)" (mouse-call-p-set 'sqn-display-previous) t]
     ["Parent (P)" (mouse-call-p-set 'imps-parent) t]
     ["First child (C)" (mouse-call-p-set 'imps-first-child) t]
     ["Next sibling (S)" (mouse-call-p-set 'imps-next-sibling )t])
    ("TeX"
     ["Xview sqn (x)" (mouse-call-p-set 'sqn-xview) t]
     ["Xview sqns" (mouse-call-p-set 'imps-xview-sqns) t]
     ["Xview dg (X)" (mouse-call-p-set 'dg-xview-dg) t]
     ["Xview thm" (mouse-call-p-set 'imps-xview-theorem) t]
     ["Xview macete" (mouse-call-p-set 'imps-xview-macete) t]
     ["Save last tex output" (mouse-call-p-set 'imps-save-tex-output) t]
     ["Print tex output" (mouse-call-p-set 'imps-print-tex-output) t])))

;;;(defconst imps-dg-panes
;;;  '(("Extend-DG"
;;;     ["command menu (?)" (mouse-call-p-set 'imps-x-command-menu) t]
;;;     ["special command menu" (mouse-call-p-set 'imps-x-special-command-menu) t]
;;;     "---"
;;;     ["macete menu" (mouse-call-p-set 'imps-x-macete-menu) t]
;;;     ["macete description buffer (C-c ?)" (mouse-call-p-set 'imps-macete-menu )t])
;;;    ("Nodes"
;;;     ["first unsupported relative " (mouse-call-p-set 'imps-first-unsupported-relative) t]
;;;     ["first unsupported descendent (F)" (mouse-call-p-set 'imps-first-unsupported-descendent) t]
;;;     ["sqn by number" (mouse-call-p-set 'sqn-select) t]
;;;     ["maximum sqn" (mouse-call-p-set 'sqn-display-max) t]
;;;     ["next sqn (n)" (mouse-call-p-set 'sqn-display-next) t]
;;;     ["previous sqn (p)" (mouse-call-p-set 'sqn-display-previous) t]
;;;     ["parent (P)" (mouse-call-p-set 'imps-parent) t]
;;;     ["first child (C)" (mouse-call-p-set 'imps-first-child) t]
;;;     ["next sibling (S)" (mouse-call-p-set 'imps-next-sibling )t])
;;;    ("TeX"
;;;     ["xview sqn (x)" (mouse-call-p-set 'sqn-xview) t]
;;;     ["xview dg (X)" (mouse-call-p-set 'dg-xview-dg) t]
;;;     ["xview thm" (mouse-call-p-set 'imps-xview-theorem) t])))

(defun imps-reset-menubar ()
  (interactive)
  (set-buffer-menubar
   (append
    default-menubar
    (if  (or (eq major-mode 'sqn-mode) (eq major-mode 'dg-mode))
	imps-dg-panes
      nil)
    (imps-proof-panes)
    imps-fundamental-panes
    (if (eq major-mode 'scheme-mode)
	scheme-mode-panes
      nil))))

(defun imps-x-command-menu (arg)
  (interactive "P")
  (let ((sqn-no (current-sqn-no))
	(dg-no dg-number))
    (message "Updating Command Menu...")
    (let ((commands 
	   (get-literal-from-tea 
	    (format "(applicable-commands (sequent-unhash-in-graph-by-number %d %d))"
		    sqn-no dg-no))))
      
      (message "Done.")
      (popup-menu
       (cons "Commands"
	     (mapcar
	      '(lambda (x)
		 (vector (command-with-key-binding x) 
			 (car (read-from-string (format "(mouse-call-p-set '(dg-apply-command \"%s\" '(%d)))"
							x
							sqn-no)))
			 't))
	      commands))))))

(defun imps-x-special-command-menu (arg)
  (interactive "P")
  (let ((sqn-no (current-sqn-no))
	(dg-no dg-number))
    (message "Updating Command Menu...")
    (let ((commands 
	   (get-literal-from-tea 
	    (format "(applicable-special-commands (sequent-unhash-in-graph-by-number %d %d))"
		    sqn-no dg-no))))
      
      (message "Done.")
      (popup-menu
       (cons "Commands"
	     (append
	      '(["apply-macete (without minor premises)" (mouse-call-p-set 'apply-macete-menu) t]
		["apply-macete-locally" (mouse-call-p-set 'apply-macete-locally-menu) t]
		["apply-macete-locally-with-minor-premises" (mouse-call-p-set 'apply-macete-locally-with-minor-premises-menu) t]
		["apply-macete-with-minor-premises" (mouse-call-p-set 'apply-macete-with-minor-premises-menu) t]
		"--"
		)
	      
	      (mapcar
	      '(lambda (x)
		 (vector (command-with-key-binding x) 
			 (car (read-from-string (format "(dg-apply-command \"%s\" '(%d))"
							x
							sqn-no)))
			 't))
	       
	       commands)))))))

(defun imps-x-macete-menu (arg)
  (interactive "P")
  (imps-x-macete-menu-aux "apply-macete-with-minor-premises"))

(defun apply-macete-menu (arg)
  (interactive "P")
  (imps-x-macete-menu-aux "apply-macete"))

(defun apply-macete-with-minor-premises-menu (arg)
  (interactive "P")
  (imps-x-macete-menu-aux "apply-macete-with-minor-premises"))

(defun apply-macete-locally-menu (arg)
  (interactive "P")
  (imps-x-macete-menu-aux "apply-macete-locally"))

(defun apply-macete-locally-with-minor-premises-menu (arg)
  (interactive "P")
  (imps-x-macete-menu-aux "apply-macete-locally-with-minor-premises"))

(defun imps-x-macete-menu-aux (macete-command)
  (let ((sqn-no (current-sqn-no))
	(dg-no dg-number))
    (message "Updating Macete Menu...")
    (let ((macetes 
	   (sort
	   (get-literal-from-tea 
	    (format "(applicable-macetes-for-sqn (sequent-unhash-in-graph-by-number %d %d))"
		    sqn-no dg-no))
	   'string-lessp)))
      
      (message "Done.")
      (if macetes
	  (popup-menu
	   (cons "Macetes "
		 (mapcar '(lambda (x)
			    (vector x 
				    (` (apply-macete-command
					(, macete-command) (, x) (, sqn-no)))
				    t))
			 macetes)))
	
	(message "No applicable macetes!")))))

(defun apply-macete-command (macete-command macete sqn-no)
  (let ((*we-already-know-the-macete-because-we-got-it-from-the-menu*
	(car (read-from-string macete))))
    (dg-apply-command macete-command (list sqn-no))))

(defun imps-reset-dump (arg)
  (interactive "P")
  (let ((in-dump-dir (directory-files (substitute-in-file-name "$IMPS/../executables") t))
	(file-menu-spec '()))
    (mapcar '(lambda (x) (if (null (car (file-attributes x)))
			     (setq file-menu-spec (cons (vector x (` (setq imps-dump-name (, x))) t) file-menu-spec))))
	    in-dump-dir)
    (popup-menu (cons "-dumps-" file-menu-spec))))

(defun imps-status (arg)
  (interactive "P")
  (let ((stat (get-literal-from-tea "(status-of-theory-network-alist)")))
    (message (mapconcat '(lambda (x) (concat (symbol-name (car x)) "=" (cdr x)))  stat " "))))
(defun set-current-theory (arg)
  (interactive "P")
  (let ((theories
	 (sort
	  (get-literal-from-tea 
	   "(theory-names-in-global-theory-table)")
	  'string-lessp)))
    (let ((string (completing-read-or-get-from-x-menu "Theory:" (mapcar 'list theories) nil nil nil)))      
      (if string (tea-eval-expression
		  (format "(set (current-theory) (name->theory '%s))" string))
	nil))))

(defun imps-load-section (arg)
  (interactive "P")
  (let ((sections
	 (sort
	  (get-literal-from-tea 
	   "(let ((accum `())) (walk-table (lambda (k v) (push accum (string-downcase (symbol->string (section-name v))))) *name-section-table*) accum)")
	  'string-lessp)))

    (let ((string (completing-read-or-get-from-x-menu "section:" (mapcar 'list sections) nil nil nil)))      
      (if string (tea-eval-expression
		  (format "(load-section %s)" string))
	nil))))

(defun imps-quick-load-section (arg)
  (interactive "P")
  (let ((sections
	 (sort
	  (get-literal-from-tea 
	   "(let ((accum `())) (walk-table (lambda (k v) (push accum (string-downcase (symbol->string (section-name v))))) *name-section-table*) accum)")
	  'string-lessp)))

    (let ((string (completing-read-or-get-from-x-menu "section:" (mapcar 'list sections) nil nil nil)))      
      (if string (tea-eval-expression
		  (format "(load-section %s quick-load)" string))
	nil))))

(defun imps-load-section-references (arg)
  (interactive "P")
  (let ((sections
	 (sort
	  (get-literal-from-tea 
	   "(let ((accum `())) (walk-table (lambda (k v) (push accum (string-downcase (symbol->string (section-name v))))) *name-section-table*) accum)")
	  'string-lessp)))
    (let ((string
	   (completing-read-or-get-from-x-menu
	    "section: "
	    (mapcar 'list sections)
	    nil nil nil)))      
      (and
       string
       (tea-eval-expression
	(format "(emacs-install-section-references '%s)" string))))))


(defun examine-theory-interpretation (arg)
  (interactive  "P")
  (let ((translations
	 (get-literal-from-tea
	  "(let ((accum '()))
               (walk (lambda (x) (if (name x) 
                                     (push accum (list (string-downcase (symbol->string (name x)))))))
                         (translations-in-global-translation-alist))
             accum)")))
    (examine-imps-object "translation" (completing-read-or-get-from-x-menu "Interpretations: " translations nil nil nil))))

(defun examine-imps-object (type name)
  (if name
      (progn
	(tea-eval-expression
	 (format "(block
             (pretty-print (name->%s '%s) (standard-output))
             (newline (standard-output))
             (pretty-print (let* ((obj (name->%s '%s)))
                (map (lambda (sel) (list (selector-id sel) (sel obj))) (stype-selectors (structure-type obj)))) (standard-output)))"
		 type name type name))
	(pop-to-buffer "*tea*"))
    nil))

;; (autoload 'imps-tutorial-formulas
;; 	  (concat (getenv "IMPS") "/../el/imps-tutorial")
;; 	  "Starts the IMPS interactive tutorial"
;; 	  t)

(defun imps-exercises (arg)
  (interactive "P")
  (require 'imps-tutorial)
  (let ((all-files (nreverse (sort (directory-files imps-exercise-directory) 'string-lessp)))
	(files '()))
    (mapcar '(lambda (x)
	       (if (string-match "\\.t$\\|\\.el$\\|\\.tex$" x)
		   (let ((y (substring x 0 (match-beginning 0))))
		     (setq files
			   (cons (vector y
					 (` (copy-and-find-exercise-file (, x)))
					 t) files)))))
	    all-files)
    (popup-menu  (cons "Exercise-Files" files))))

(defun copy-and-find-exercise-file (filename)
  (let ((imps-filename (concat imps-exercise-directory "/" filename))
	(copy-filename (concat "~/imps/theories/" filename)))
    (copy-file imps-filename  copy-filename 1)
    (find-file copy-filename)
    (delete-all-exercise-proofs)
    (save-buffer)
    (set-marker imps-exercise-already-sent-marker (point-min))
    (imps-exercise-next-target)))

;;This is redefined

(defun completing-read-or-get-from-x-menu (prompt table predicate require-match initial-input)

  (if (and (featurep 'imps-lucid-support)
	   (boundp 'imps-mouse-call-p)
	   imps-mouse-call-p
	   (listp table)
	   (<= (length table) *max-menu-size*))
      (progn (setq initial-input nil)
	     (popup-menu-insert-in-minibuffer (mapcar 'car table))))

  (or (catch 'cancel-menu-request
	(completing-read prompt table predicate require-match initial-input))
      (keyboard-quit)))



(defun insert-in-minibuffer (str &optional erase)
  "Inserts STR in minibuffer."
  (set-buffer (window-buffer (minibuffer-window)))
  (if erase (erase-buffer))
  (insert str)
  (select-window (minibuffer-window)))

(defun insert-in-minibuffer-and-exit (str &optional erase)
  "Inserts STR in minibuffer."
  (insert-in-minibuffer str erase)
  (exit-minibuffer))

(defun popup-menu-insert-in-minibuffer (l)
  (popup-menu 
   (cons "Menu"
	 (append
	  (mapcar
		 '(lambda (x)
		    (vector x (` (insert-in-minibuffer-and-exit (, x))) t))
		 l)
	  (list 	
	   "---"
	   (vector "CANCEL MENU REQUEST" '(throw 'cancel-menu-request nil) t)
	   )))))


;;;Additional mouse support for imps.

;;We assume formulas are separated by  *formula-terminator-string*:
(defvar *formula-terminator-string* "\n\n")

(defun x-mouse-activate-point-to-mouse (event)
  "Activate the region between point and mouse.  Copy text object at point or
mouse position into window system cut buffer.  Save in Emacs kill ring also." 
  (interactive "@e")
  (let* ((here (point))
	 (there
	  (save-excursion (mouse-set-point event) (point)))
	 (s (buffer-substring here there)))
    (x-own-clipboard s)
    (x-store-cutbuffer s)
    (copy-region-as-kill here there)
    (push-mark there)
    (zmacs-activate-region)))

(defconst assumption-number-mouse-hook
  '(lambda (event)
     (let ((numb 
	    (save-excursion 
	      (mouse-count-occurrences-backwards
	       *formula-terminator-string*
	       assumption-assertion-separator
	       event ))))

       (if (numberp numb) (insert-in-minibuffer (format "%s " numb))))))


(defun count-occurrences-backwards (regexp)
  (save-excursion
    (let ((count 0)
	  (beg (point-min)))
      (while (re-search-backward regexp beg t)
	(setq count (1+ count)))
      count)))

(defun mouse-count-occurrences-backwards (terminator boundary event)
  (save-excursion
    (save-window-excursion
      (mouse-set-point event)
      (if (eq (current-buffer) current-sequent-buffer) 
	  (if (or (and (looking-at "[ \t\n]\\|\\'")
		       (save-excursion
			 (skip-chars-backward " \t\n")
			 (looking-at terminator)))
		  (save-excursion
		    (beginning-of-line)
		    (looking-at (concat "[ \t]*" boundary "\n\n")))
		  (save-excursion
		    (re-search-backward boundary (point-min) t)))
	      (progn
		(message "Mouse not pointing at assumption.") (ding) nil)
	    (count-occurrences-backwards terminator))
	(progn (message "Mouse is in wrong buffer!") (ding) nil)))))


;;;Grabbing expressions with the mouse:

(defconst expression-grabber-mouse-hook
  'mouse-locate-containing-expression)

(defconst left-delimiter-for-imps-expressions "\"")
(defconst right-delimiter-for-imps-expressions "\"")
					;(defconst regexp-for-imps-expressions "\"[^\"]+\"")

(defun locate-containing-expression ()
  (save-excursion
    (let ((beg nil) (end nil))
      (re-search-forward right-delimiter-for-imps-expressions (point-max) t)
      (setq end (point))
      (goto-char (match-beginning 0))
      (if end
	  (progn
	    (re-search-backward left-delimiter-for-imps-expressions (point-min) t)
	    (setq beg (point))
	    (goto-char (match-end 0))
	    (if beg 
		(format "%s" (buffer-substring (1+ beg) (- end 1)))
	      nil))
	nil))))

(defun mouse-locate-containing-expression (event)
  (save-excursion
    (save-window-excursion
      (mouse-set-point event)
      (let ((expr (locate-containing-expression)))
	(cond ((null expr) (ding) (message "Not pointing to anything which is recognizably an expression.") nil)
	      (t (insert-in-minibuffer expr t))))))
  (select-window (minibuffer-window)))

(setq dg-mode-hook '(set-local-buttons-hook imps-reset-menubar))

(setq sqn-mode-hook '(set-local-buttons-hook imps-reset-menubar))

(add-hook 'scheme-mode-hook 'set-local-buttons-hook t)
(add-hook 'scheme-mode-hook 'imps-reset-menubar t)

(setq inferior-tea-mode-hook '(set-local-buttons-hook imps-reset-menubar))

