#ifndef NUL
#define NUL '\0'
#endif

#define MAX_COM 1000
#define MAX_PAR 100

typedef char **Names;
typedef char *CharClass;

struct COMMAND
  {
    int no;
	int noOfPars;
	char** pars;
	Names names;
  };
typedef struct COMMAND COMMAND;
typedef int (*CMDPROC)();

struct TextElem
  {
    char *text;
	char *pos;
	PROC proc;
  };
typedef struct TextElem TextElem;
    
struct CMDMODES
  {
    int		ignoreCases;
	int		maxPars;
	char*	prompt;
	TextElem	*textStack;
	int		maxCmdStack;
	int		cmdStackP;
	int		noOfNames;
	int		maxIndex;
	Names	names;
	int*	index;
	CMDPROC*	procs;
	char**	shortDes;
	Names*	pars;
	CharClass	delimClass;
	COMMAND*	cmd;
	char	escape;
	char	comment;
  };
typedef struct CMDMODES CMDMODES;

extern int		InitCommands();
extern int		DoCommands();
extern int		ExecCommand();
extern COMMAND*	GetNextCommand();
extern void		SetCommand();

extern void		PrintCmdSettings();
extern void		PrintNames();
extern int		CheckName();
extern int		ParsCheck();
extern char		*ConvertString();

extern CMDMODES	stdCmdModes;

#define endClass 127
#define commandClass 10
#define parameterClass 5
#define nameClass 5
#define quoteClass 1
