// Ring of complex numbers.

// General includes.
#include "cl_sysdep.h"

CL_PROVIDE(cl_C_ring)

// Specification.
#include "cl_ring.h"


// Implementation.

#include "cl_complex.h"
#include "cl_C.h"

static void N_fprint (cl_heap_ring* R, cl_ostream stream, const _cl_ring_element& x)
{
	unused R;
	fprint(stream,The(cl_N)(x));
}

static cl_boolean N_equal (cl_heap_ring* R, const _cl_ring_element& x, const _cl_ring_element& y)
{
	unused R;
	return cl_equal(The(cl_N)(x),The(cl_N)(y));
}

static _cl_ring_element N_zero (cl_heap_ring* R)
{
	return _cl_ring_element(R, (cl_N)0);
}

static cl_boolean N_zerop (cl_heap_ring* R, const _cl_ring_element& x)
{
	unused R;
	// Here we return true only if x is the *exact* zero. Because we
	// don't want the degree of polynomials to depend on rounding errors.
	// For all ring theoretic purposes, we treat 0.0, 0+0.0i etc. as if
	// they were zero divisors.
	return exact_zerop(The(cl_N)(x));
}

static _cl_ring_element N_plus (cl_heap_ring* R, const _cl_ring_element& x, const _cl_ring_element& y)
{
	return _cl_ring_element(R, The(cl_N)(x) + The(cl_N)(y));
}

static _cl_ring_element N_minus (cl_heap_ring* R, const _cl_ring_element& x, const _cl_ring_element& y)
{
	return _cl_ring_element(R, The(cl_N)(x) - The(cl_N)(y));
}

static _cl_ring_element N_uminus (cl_heap_ring* R, const _cl_ring_element& x)
{
	return _cl_ring_element(R, - The(cl_N)(x));
}

static _cl_ring_element N_one (cl_heap_ring* R)
{
	return _cl_ring_element(R, (cl_N)1);
}

static _cl_ring_element N_canonhom (cl_heap_ring* R, const cl_I& x)
{
	return _cl_ring_element(R, (cl_N)x);
}

static _cl_ring_element N_mul (cl_heap_ring* R, const _cl_ring_element& x, const _cl_ring_element& y)
{
	return _cl_ring_element(R, The(cl_N)(x) * The(cl_N)(y));
}

static _cl_ring_element N_square (cl_heap_ring* R, const _cl_ring_element& x)
{
	return _cl_ring_element(R, square(The(cl_N)(x)));
}

static _cl_ring_element N_expt_pos (cl_heap_ring* R, const _cl_ring_element& x, const cl_I& y)
{
	return _cl_ring_element(R, expt(The(cl_N)(x),y));
}

static cl_ring_setops N_setops = {
	N_fprint,
	N_equal
};
static cl_ring_addops N_addops = {
	N_zero,
	N_zerop,
	N_plus,
	N_minus,
	N_uminus
};
static cl_ring_mulops N_mulops = {
	N_one,
	N_canonhom,
	N_mul,
	N_square,
	N_expt_pos
};

static cl_number_ring_ops<cl_N> N_ops = {
	cl_equal,
	exact_zerop,
	operator+,
	operator-,
	operator-,
	operator*,
	square,
	expt
};

class cl_heap_complex_ring : public cl_heap_number_ring {
	SUBCLASS_cl_heap_ring()
public:
	// Constructor.
	cl_heap_complex_ring ()
		: cl_heap_number_ring (&N_setops,&N_addops,&N_mulops,
		                       &N_ops)
		{ typetag = cl_typetag_complex_ring; }
	// Destructor.
	~cl_heap_complex_ring () {}
};

static void cl_complex_ring_destructor (cl_heap* pointer)
{
	(*(cl_heap_complex_ring*)pointer).~cl_heap_complex_ring();
}
AT_INITIALIZATION(ini_cl_complex_ring)
{ cl_register_typetag(cl_typetag_complex_ring,cl_complex_ring_destructor); }

// Constructor.
inline cl_complex_ring::cl_specialized_number_ring ()
	: cl_ring (new cl_heap_complex_ring()) {}

cl_complex_ring cl_C_ring;

CL_PROVIDE_END(cl_C_ring)
