// This may look like C code, but it is really -*- C++ -*-
#define CASE break; case 
#include "point.h"
#define sin60  .866025

const int Dimensions = 2;
Int All8Neighbor[ 8][ Dimensions] = {
  {-1,0}, // left
  {-1,1}, // up left
  {0,1}, // up
  {1,1}, // up right
  {1,0}, // right
  {1,-1}, //down right
  {0,-1}, // down
  {-1,-1} // down left
};

#ifdef  EIGHT_NEIGHBORHOOD
  Int DirNeighbor[ NumberOfNeighbors + 1][ Dimensions] = {
    {-1,0}, // left
    {-1,1}, // up left
    {0,1}, // up
    {1,1}, // up right
    {1,0}, // right
    {1,-1}, //down right
    {0,-1}, // down
    {-1,-1} // down left
  };
  Float FDirNeighbor[ NumberOfNeighbors + 1][ Dimensions] = {
    {-1,0}, // left
    {-1,1}, // up left
    {0,1}, // up
    {1,1}, // up right
    {1,0}, // right
    {1,-1}, //down right
    {0,-1}, // down
    {-1,-1} // down left
  };
#else
  const Int DirNeighbor[ NumberOfNeighbors + 1][ Dimensions] = {
    {-1,0}, // left
    {-1,1}, // up left
    {0,1}, // up
    {1,0}, // right
    {1,-1}, //down right
    {0,-1} // down
  };
  Float FDirNeighbor[ NumberOfNeighbors + 1][ Dimensions] = {
    {-1,0}, // left
    {-0.5,sin60}, // up left
    {0.5,sin60}, // up
    {1,0}, // right
    {0.5,-sin60}, //down right
    {-0.5,-sin60} // down
  };
#endif

void
PointList::AddTriangle( int x1, int y1,int x2, int y2, int x3, int y3)
    // returns a list of point which are inside the triangle specified 
{
  if ((y2 < y3 && y2 < y1) || (y2 <= y3 && y2 < y1 && x2 < x3) || 
      (y2 < y3 && y2 <= y1 && x2 <= x1)){ 
    swap(x1,x2);
    swap(y1,y2);
  }
  if (y3 < y2 && y3 < y1 || (y3 <= y2 && y3 < y1 && x3 < x2) || 
      (y3 < y2 && y3 <= y1 && x3 <= x1)) {
    swap(x1,x3);
    swap(y1,y3);
  }
      // (x1,y1) is the lowest point, if not unique then the lower leftmost
      // point 
  if (x3 < x2 || (x3==x2 && y3 < y2)) {
    swap(x2,x3);
    swap(y2,y3);
  }
      // make (x2,y2) the left point, so we can scan from left to right
  int ymax = (y2>y3)?y2:y3;
  int ychange = (y2>y3)?y3:y2; // The value of y where the line being scanned
			       // changes 
  float xleft = x1; // will scan from xleft to xright
  float xright = (y1==y3)?x3:x1; // xright is x1 unless, the lowest edge is
			       // parallel to the x-axis
  float leftslope = 1.0*(x2-x1)/(y2-y1);
  float rightslope;
  int y,x;
  if (y3 - y1 != 0) { // if no lower horizontal line
      // line 
    rightslope = 1.0*(x3-x1)/(y3-y1);
    for( y = y1; y <= ychange; y++) 
      for ( x = floatToInt( xleft + leftslope*(y-y1));
	    x <= floatToInt( xright + rightslope*(y-y1)); x++) {
	insert(Point(x,y));
      }
    if (y2 == y3) // horizontal top line
      return;
    xleft += leftslope*(ychange-y1);
    xright += rightslope*(ychange-y1);
    if (y2 < y3) {//left line changes
      leftslope = 1.0*(x3-x2)/(y3-y2);
    }
    else {//right line changes
      rightslope = 1.0*(x2-x3)/(y2-y3);
    }
    for(y = ychange + 1; y <= ymax; y++) 
      for (x = floatToInt( xleft + leftslope*(y-ychange));
	   x <= floatToInt( xright + rightslope*(y-ychange)); x++) {
	insert(Point(x,y));
      }
  }
  else {
    rightslope = 1.0*(x2-x3)/(y2-y3);
    for(y = ychange ; y <= ymax; y++) 
      for (x = floatToInt( xleft + leftslope*(y-ychange));
	   x <= floatToInt( xright + rightslope*(y-ychange)); x++) {
	insert(Point(x,y));
      }
  }
}

void
PointList::AddRectangle( int x1, int y1,int x2, int y2)
    // returns a list of point which are inside the rectangle specified 
{
  int x,y;

  if (x1 > x2) swap(x1,x2);
  if (y1 > y2) swap(y1,y2);
  for( y = y1; y <= y2; y++) 
    for ( x = x1; x <= x2; x++) 
      insert(Point(x,y));
}


void
PointList::AddHexagon( int cx, int cy,int r)
    // returns a list of point which are inside the hexagon specified 
{
  int x,y;
  for ( y = r; y>= 0; y--) 
    for ( x= -r;x<= r-y; x++) 
      insert(Point(cx+x,cy+y));
  for ( y = -1; y>= -r; y--) 
    for ( x= -r-y;x<= r; x++)
      insert(Point(cx+x,cy+y));
}

void
PointList::AddCircle( int cx, int cy, int r)
    // returns a list of point which are inside the circle specified 
{
  // Bresenham's circle drawing algorithm P. 445 Foley, Van Dam
  int size = 2*r+1;
  unsigned char tag[ (2*r+1)*( 2*r+1)];
  for (int i=0;i < (2*r+1)*( 2*r+1); i++) tag[i]=0;
  int x = 0;
  int y = r;
  int d = 3 - 2 * r;
  while (x < y) {
    diskPoints( x, y, tag, r);
    if (d < 0) d += 4 * x + 6;
    else {
      d += 4 * (x - y) + 10;
      y--;
    }
    x++;
  }
  if (x == y) diskPoints( x, y, tag, r);
  for (y = 0; y< size; y++) 
    for (x=0; x< size; x++) 
      if (tag [ y*(2*r+1) + x]) insert(cx+x-r, cy+y-r);
}

void
PointList::diskPoints( int x, int y, unsigned char *tag , int r)
{
// Multiply the 45 deg sector generated and also fill it in. 
  line( + x, + y, - x, + y, tag, r );
  line( + x, + y, + x, - y, tag, r );
  line( + y, + x, + y, - x, tag, r );
  line( + y, + x, - y, + x, tag, r );
  line( - x, - y, - x, + y, tag, r );
  line( - x, - y, + x, - y, tag, r );
  line( - y, - x, + y, - x, tag, r );
  line( - y, - x, - y, + x, tag, r );
}


void 
PointList::line( int x1, int y1, int x2, int y2, unsigned char *tag , int r) 
// Draw a line between the two specified points, either x or y is
// guaranteed to be the same for both points, used only by diskPoints
{
  if (x1 > x2) swap (x1, x2);
  if (y1 > y2) swap (y1, y2);
  for (int y=y1; y<=y2; y++)
    for (int x=x1; x<=x2; x++)
    tag[ (r + y)* (2*r+1) + r + x] = 1;
}

Point random6Direction()
{
  int i = randBetween( 0, NumberOfNeighbors);
  return ( Point( DirNeighbor[i][0], DirNeighbor[i][1]));
}


PointList::PointList(const PointList& pl)
{
  if (pl.list == NULL) {
    list = end = (Point *) NULL;
  }
  else {
    Point *tmp = pl.list;
    end = list = new Point(*tmp);
    Point* prev = list;
    tmp=tmp->next;
    while (tmp != NULL) {
      end = new Point(*tmp);
      prev->next = end;
      prev = end;
      tmp = tmp->next;
    }
  }
}

PointList::~PointList() {
  Point *tmp;
  while (list != NULL) {
    tmp = list;
    list = list->next;
    delete tmp;
  }
}

PointList& PointList::operator=(const PointList& pl)
{
  if (this == &pl) return *this;
  
  deleteList();
  if (pl.list == NULL) {
    list = end = (Point *) NULL;
    return *this;
  }
  Point *tmp = pl.list;
  end = list = new Point(*tmp);
  Point* prev = list;
  tmp=tmp->next;
  while (tmp != NULL) {
    end = new Point(*tmp);
    prev->next = end;
    prev = end;
    tmp = tmp->next;
  }
  return *this;
}

void PointList::insert(Int x, Int y)
{ //Add to the back of the list
  Point *pt = new Point(x,y);
  if (list == NULL) 
    {end = list = pt;}
  else
    {end->next = pt;  end=pt; }
}

bool PointList::insertNonDuplicate(const Point& p)
{ //Add to the list if not already there, returns TRUE if addition increased
  //list length
  if (list == NULL) {
    Point *pt = new Point(p.x_,p.y_);
    end = list = pt; 
    return TRUE;
  }
  else {
    Point *tmp = list;
    while (tmp != NULL && (tmp->x_ != p.x_ || tmp->y_ != p.y_)) 
      tmp = tmp->next; 
    if (tmp == NULL) {
      Point *pt = new Point(p.x_, p.y_);
      end->next = pt;  end=pt; 
      return TRUE;
    }
    else return FALSE; //  point found
  }
}

void
PointList::deleteList()
{
  Point *temp;
  while (list != NULL) {
    temp =list->next;
    //cout << "\n deleting list item " << *list;
    delete list; 
    list = temp;
  }
}

int
PointList::length() const
{
  int l = 0;
  Point* temp = list;
   while (temp != NULL) {temp = temp->next; l++;}
//  cout << " in length " << l << '\n';
  return l;
}

Point PointList::delget()
{
  if (list != NULL){
    Point p( *list);
    Point *tmp = list;
    list = list->next;
    delete tmp;
    return(p);
  }
  else
    error("error in PointList::delget, attempt to delete item from empty list");
  return( Point(0,0)); // dummy return value
}

Point PointList::middle() const
{
  Point* temp = list;
  for (int i = 1; i <= length()/2; i++)
    temp = temp->next;
  return( *temp);
}

void
PointList::display( ostream& s) const 
{
  Point *temp = list;
  s << "PL: ";
  while (temp != NULL) { temp->display(s); temp=temp->next;}
  s << ":PL\n";
}
void Point::swap( Point& p)
{
  int tx = p.x_;
  p.x_ = x_;
  x_ = tx;
  int ty = p.y_;
  p.y_ = y_;
  y_ = ty;
}

void PointList::addNeighbors( const Point& p)
{ // Appends to the point list all the neighbors of the point
  
  // No range checking now, to check range either Tissue must be passed so its
  // height and width can be accessed or a global tissue assumed.

  for (int i = 0; i < NumberOfNeighbors; i++)
    insert(p.x_ + DirNeighbor[i][0], p.y_ + DirNeighbor[i][1]);
}

void PointList::addNeighborsInReverse( const Point& p)
{ // Appends to the point list all the neighbors of the point
  
  // No range checking now, to check range either Tissue must be passed so its
  // height and width can be accessed or a global tissue assumed.

  for (int i = NumberOfNeighbors - 1; i >= 0; i--)
    insert(p.x_ + DirNeighbor[i][0], p.y_ + DirNeighbor[i][1]);
}

void PointList::addNonDuplicateNeighbors( const Point& p)
{ // Appends to the point list all the neighbors of the point
  
  // No range checking now, to check range either Tissue must be passed so its
  // height and width can be accessed or a global tissue assumed.

  for (int i = 0; i < NumberOfNeighbors; i++)
    insertNonDuplicate( Point(p.x_ + DirNeighbor[i][0], p.y_ + DirNeighbor[i][1]));
}

bool
Point::ifNeighbor(Point p)
{ // Checks if point p is a neighbor
  
  // No range checking now, to check range either Tissue must be passed so its
  // height and width can be accessed or a global tissue assumed.

  for (int i = 0; i < NumberOfNeighbors; i++)
    if ( (x_ + DirNeighbor[i][0] == p.x_) &&
	(y_ + DirNeighbor[i][1] == p.y_)) return (TRUE);
  return (FALSE);
}

Point
Point::nextPointInRotation( Point p)
{ 
   // Returns the next point in rotation of the vector a->b
   // a & b must be neighbors

  int i;
  for (i = 0; i < NumberOfNeighbors; i++)
    if ( (x_ + DirNeighbor[i][0] == p.x_) &&
	 (y_ + DirNeighbor[i][1] == p.y_)) break;
  if (i < NumberOfNeighbors - 1)
    return ( Point( x_ + DirNeighbor[i+1][0], y_ + DirNeighbor[i+1][1]));
  if (i == NumberOfNeighbors - 1)
    return ( Point( x_ + DirNeighbor[0][0], y_ + DirNeighbor[0][1]));
  cerr << p; print();
  error(" Points not neighborly in nextPointInRotation");
  return( Point(0,0)); // dummy return value
}

Point
FPoint::closestPoint() const
{
  float max = 9999999 *999999;
  Point retP;
  for (int i = 0; i < NumberOfNeighbors; i++)
    if ( distanceSquared( 
		 FPoint( FDirNeighbor[i][0], FDirNeighbor[i][1]))
			 < max) {
	  max = distanceSquared( FPoint( FDirNeighbor[i][0], FDirNeighbor[i][1]));
	  retP = Point( DirNeighbor[i][0], DirNeighbor[i][1]);
	}
  return ( retP);
}

FPoint
Point::directionFloat(Point p) const
{
  for (int i = 0; i < NumberOfNeighbors; i++)
    if ( (x_ + DirNeighbor[i][0] == p.x_) &&
	 (y_ + DirNeighbor[i][1] == p.y_)) 
    return ( FPoint( x_+FDirNeighbor[i][0],
		     y_+FDirNeighbor[i][1]));
  cerr << p << i; print( cerr);
  error(" Points not neighborly in direction FLoat");
  return( FPoint(0,0)); // dummy return value
}

FPoint
Point::relDirectionFloat(Point p) const
{
  for (int i = 0; i < NumberOfNeighbors; i++)
    if ( (x_ + DirNeighbor[i][0] == p.x_) &&
	(y_ + DirNeighbor[i][1] == p.y_)) 
      return ( FPoint( FDirNeighbor[i][0],
		      FDirNeighbor[i][1]));
  cerr << p; print(cerr);
  error(" Points not neighborly in rel direction FLoat");
  return( FPoint(0,0)); // dummy return value
}

FPoint
PointList::perpendicular()
{ 
  // Computes the perpendicular to the given list of adjoining points
  // Assume boundary is listed clockwise, so rotation by 90 will 
  // give exterior direction which is multiplication by matrix 
  // (0,1;-1,0) of (x2-x1,y2-y1) == ( y1-y2, x2-x1)

  FPoint direction(0,0);
  if (list == NULL) return direction;
  Point* first = list;
  Point* second = list->next;
  while (second != NULL) {
    direction += first->relDirectionFloat( *second);
    first = second;
    second = second->next;
  }
  return direction.perpendicular();
}

bool
PointList::contiguous()
{ 
  // check if the points in the list are neighborly, (i-1) is i's neighbor
  if (list == NULL) return TRUE;
  Point* first = list;
  Point* second = list->next;
  while (second != NULL) {
    if (!first->ifNeighbor( *second)) return FALSE;
    first = second;
    second = second->next;
  }
  return TRUE;
}

void PointList::append(const PointList& pl) {
  // copy pl behind the list
  if (pl.emptyList()) return;
  Point* item = pl.list;
  if (list == NULL) { list = end = new Point(*item); item= item->next;}
  while (item != NULL) {
    Point* insertItem = new Point(*item);
    end->next = insertItem;
    end = insertItem;
    item = item->next;
  }
  end->next = (Point *) NULL;
}


void 
Point::saveState( ostream& s)
{
  s << x_ << ' ' << y_ <<'\n';
}

void 
Point::recoverState( istream& s)
{
  s >> x_  >> y_ ;
}

void 
FPoint::saveState( ostream& s)
{
  s << x << ' ' << y <<'\n';
}

void 
FPoint::recoverState( istream& s)
{
  s >> x  >> y ;
}

