/****************************************************************************
**
**    storepc.c                       NQ                       Werner Nickel
**
**    Copyright 1992                            Mathematics Research Section
**                                           School of Mathematical Sciences 
**                                            Australian National University
*/

#include "pc.h"
#include "collect.h"

int	NrPcGens = 0;
int	NrCenGens = 0;
int	Debug = 0;
int	IsFinite;
int	IsWeighted = 0;
int	Class;

word	**Conjugate = (word **)0;
word	*Power = (word *)0;
gen	*Commute  =(gen *)0;
exp	*Exponent = (exp *)0;
int	*Weight = (int *)0;
int	*Dimension = (int *)0;

def	*Definition = (def *)0;

char	**PcGenName;

static	void	StoreError( str )
char	*str;

{	InitPrint( stdout );
	printf( "%s:\n    ", str );
	PrintNode( CurrentRelation() );
	printf( "\n" );
	fflush( stdout );

	exit( 7 );
}

void	StorePower( g, e, rhs, defining )
gen	g;
exp	e;
word	rhs;
int	defining;

{	if( NrPcGens == 0 ) NrPcGens = NumberOfGens();
	
	if( e <= 0 ) StoreError( "Negative power not allowed" );

	if( Exponent == (exp *)0 )
	    Exponent = (exp *)Allocate( (NrPcGens+1)*sizeof(exp) );
	if( Power == (word *)0 )
	    Power = (word *)Allocate( (NrPcGens+1)*sizeof(word) );

	if( Exponent[g] != (exp)0 )
	    StoreError( "Duplicate power relation" );
	Exponent[g] = e;
	Power[g] = rhs;
	if( rhs == (word)0 ) return;

	while( rhs->g != EOW ) {
	    if( abs(rhs->g) <= g )
		StoreError( "Wrong right hand side" );
	    rhs++;
	}

	if( defining ) {
	    if( Definition == (def *)0 )
		Definition = (def *)Allocate( (NrPcGens+1)*sizeof(def) );
	    defining = GEStrLength(Power[g])-1;
	    if( Power[g][defining].e != 1 )
		StoreError( "Defined generator doesn't have exponent 1" );
	    if( Definition[ Power[g][defining].g ].h != 0 )
		StoreError( "Duplicate definition" );
	    Definition[ abs(Power[g][defining].g) ].h = g;
	    Definition[ abs(Power[g][defining].g) ].g = 0;
	}
}

void	StoreConj( h, g, rhs, defining )
gen	h, g;
word	rhs;
int	defining;

{	if( NrPcGens == 0 ) NrPcGens = NumberOfGens();

	/* g might be the inverse of a generator. */
	if( h <= abs(g) )
	    StoreError( "Wrong left hand side" );

	if( Conjugate == (word **)0 ) {
	    Conjugate = (word **)Allocate( (2*NrPcGens+1)*sizeof(word *) );
	    Conjugate += NrPcGens;
	}
	if( Conjugate[h] == (word *)0 ) {
	    Conjugate[h] = (word *)Allocate( (2*(h-1)+1)*sizeof(word) );
	    Conjugate[h] += h-1;
	}

	if( Conjugate[h][g] != (word)0 )
	    StoreError( "Duplicate conjugate relation" );
	Conjugate[h][g] = rhs;

	while( rhs->g != EOW ) {
	    if( abs(rhs->g) <= abs(g) )
		StoreError( "Wrong right hand side" );
	    rhs++;
	}

	if( defining ) {
	    if( Definition == (def *)0 )
		Definition = (def *)Allocate( (NrPcGens+1)*sizeof(def) );
	    defining = GEStrLength(Conjugate[h][g])-1;
	    if( Conjugate[h][g][defining].e != 1 )
		StoreError( "Defined generator doesn't have exponent 1" );
	    if( Definition[ Conjugate[h][g][defining].g ].h != 0 )
		StoreError( "Duplicate definition" );
	    Definition[ abs(Conjugate[h][g][defining].g) ].h = h;
	    Definition[ abs(Conjugate[h][g][defining].g) ].g = g;
	}
}

static	int	DoNotCommute( h, g )
gen	h, g;

{	if( Conjugate          == (word**)0 ) return 0;
	if( Conjugate[h]       ==  (word*)0 ) return 0;
	if( Conjugate[h][g]    ==   (word)0 ) return 0;
	if( Conjugate[h][g][0].g == h &&
	    Conjugate[h][g][0].e == 1 &&
	    Conjugate[h][g][1].g == EOW )     return 0;

	return 1;
}

void	CompletePcPres() {

	gen	g, h;
	extern	word	GEStrGen();

	/* First fix Exponent in case there are no power relations. */
	if( Exponent == (exp*)0 )
	    Exponent = (exp*)Allocate( (NrPcGens+NrCenGens+1)*sizeof(exp) );

	if( Commute != (gen *)0 ) Free( Commute );

	Commute = (gen *)Allocate( (NrPcGens+NrCenGens+1)*sizeof(gen) );
	/*
	**    Commute[i] is the smallest j >= i such that a_i,...,a_n
	**    commute with a_(j+1),...,a_n.
	*/
	Commute[NrCenGens+NrPcGens] = NrCenGens+NrPcGens;
	for( g = NrCenGens+NrPcGens-1; g >= 1; g-- ) {
	    /*
	    **    After the following loop two cases can occur :
	    **    a) h > g+1. In this case h is the first generator among
	    **       a_n,...,a_(j+1) with which g does not commute.
	    **    b) h == g+1. Then Commute[g+1] == g+1 follows and g
	    **       commutes with all generators a_(g+2),..,a_n. So it
	    **       has to be checked whether a_g and a_(g+1) commute.
	    **       If that is the case, then Commute[g] = g. If not
	    **       then Commute[g] = g+1 = h.
	    */
	    for( h = NrCenGens+NrPcGens; h > Commute[g+1]; h-- )
		if( DoNotCommute( h, g ) )
		    break;

	    if( h == g+1 && !DoNotCommute(h,g) )
		    Commute[g] = g;
	    else    Commute[g] = h;
	}
	    
/*	printf( "[ %d", Commute[1] );
	for( g = 2; g <= NrPcGens+NrCenGens; g++ )
	    printf( ", %d", Commute[g] );
	printf( " ]\n" );
*/
	/*    Now complete the polycyclic presentation such that the
	**    collector works.
	**
	**    The collector could try to access the conjugates h^g
	**    for all g < h <= Commute[g].
	*/
	for( g = 1; g <= NrPcGens+NrCenGens; g++ )
	    for( h = g+1; h <= Commute[g]; h++ ) {
		if( Conjugate[h] == (word *)0 ) {
		    Conjugate[h] = (word *)Allocate( (2*(h-1)+1)*sizeof(word) );
		    Conjugate[h] += h-1;
		}
		if( Conjugate[h][g] == (word)0 )
		    Conjugate[h][g] = GEStrGen(h);
		if( Exponent[g] == 0 && Conjugate[h][-g] == (word)0 )
		    Conjugate[h][-g] = GEStrGen(h);
	    }

	if( IsFinite ) return;
	/*
	**    If the polycyclic presentation has a generator a which does not
	**    have a power relation then for this generators the relations
	**    (a^-1)^b for all generators b must be added to the set of
	**    conjugate relations.
	**    Note that in general it is not easy to compute relations
	**    with lhs b^(a^-1) from the other relations if a has no power
	**    relation. In fact it is impossible if the group given is not
	**    polycyclic. But if the polycyclic presentation comes from
	**    a polycyclic series that refines a chief series, it can be
	**    done.
	**    The code for this is not written yet.
	*/
	for( g = NrPcGens; g >= 1; g-- )
	    for( h = Commute[g]; h >= g+1; h-- )
	        if( Exponent[h] == 0 ) {
		    if( Conjugate[-h] == (word *)0 ) {
			Conjugate[-h] =
			    (word *)Allocate( (2*(h-1)+1)*sizeof(word) );
			Conjugate[-h] += h-1;
		    }
/*		    if( Conjugate[-h][g] != (word)0 )*/
/*			Free( Conjugate[-h][g] );*/
		    Conjugate[-h][g] = Invert( Conjugate[h][g] );
		    if( Exponent[g] == 0 ) {
/*			if( Conjugate[-h][g] != (word)0 )*/
/*			    Free( Conjugate[-h][-g] );*/
			Conjugate[-h][-g] = Invert( Conjugate[h][-g] );
		    }
		}
}

void	ExtendPower( g, rhs )
gen	g;
word	rhs;

{	int	lrhs;
	gen	a;

/*	printf( "ExtendPower( %d )\n", g );*/
	a = NrPcGens+NrCenGens+1;

	if( rhs == (word)0 ) {
	    rhs = (word)Allocate( 2*sizeof(gpower) );
	    rhs[0].g = a;   rhs[0].e = 1;
	    rhs[1].g = EOW; rhs[1].e = 0;
	}
	else {
	    lrhs = GEStrLength( rhs );
	    rhs = (word)ReAllocate( rhs, (lrhs+2)*sizeof(gpower) );
	    rhs[lrhs].g = a;     rhs[lrhs].e = 1;
	    rhs[lrhs+1].g = EOW; rhs[lrhs+1].e = 0;
	}
	Power[g] = rhs;
	Definition[a].h = g;
	Definition[a].g = 0;
	NrCenGens++;
}

void	ExtendConj( h, g, rhs )
gen	h, g;
word	rhs;

{	int	lrhs;
	gen	a;

/*	printf( "ExtendConj( %d, %d )\n", h, g );*/

	a = NrPcGens+NrCenGens+1;

	if( rhs == (word)0 ) {
	    rhs = (word)Allocate( 3*sizeof(gpower) );
	    rhs[0].g = h;   rhs[0].e = 1;
	    rhs[1].g = a;   rhs[1].e = 1;
	    rhs[2].g = EOW; rhs[2].e = 0;
	}
	else {
	    lrhs = GEStrLength( rhs );
	    rhs = (word)ReAllocate( rhs, (lrhs+2)*sizeof(gpower) );
	    rhs[lrhs].g = a;     rhs[lrhs].e = 1;
	    rhs[lrhs+1].g = EOW; rhs[lrhs+1].e = 0;
	}
	Conjugate[h][g] = rhs;
	Definition[a].h = h;
	Definition[a].g = g;
	NrCenGens++;
}

CountNrNewGens() {

	int	nrNewGens;
	gen	g;

	if( IsWeighted ) {
	    int	d = Dimension[1];
	    nrNewGens = NrPcGens * d - d * (d+1) / 2;
	}
	else
	    nrNewGens = NrPcGens * (NrPcGens-1) / 2;

	/* Now add one new generator for each power relation. */
	if( IsFinite )
	    nrNewGens += NrPcGens;
	else
	    for( g = 1; g <= NrPcGens; g++ )
		if( Exponent[g] > 0 )
		    nrNewGens++;

	/* Add one for each image that is not a definition. */
	if( Map != (word *)0 ) nrNewGens += NrImages;

	/* Now subtract one new generator for each generator
	   defined by a power or a commutator relation or by an
	   image under the epimorphism. */
	if( Definition != (def*)0 )
	    for( g = 1; g <= NrPcGens; g++ ) 
		if( Definition[g].h != 0 )
		    nrNewGens--;

/*	printf( "Nr of new generators: %d\n", nrNewGens ); */
}

#define	MARK    0x1
#define	UNMARK ~0x1
ExtendPcPres() {

	gen	a, g, h;
	word	**NewConj;
	int	nrNewGens;

	CountNrNewGens();
	/* At first the pointers to the defining relations are marked
	** and the number of new generators are counted.              */
	if( IsFinite ) nrNewGens = (NrPcGens+1)*NrPcGens/2;
	else {  nrNewGens = NrPcGens * NrPcGens;
		for( a = 1; a <= NrPcGens; a++ )
		    if( Exponent[a] == 0 ) nrNewGens--;
		    else                   nrNewGens -= (NrPcGens-a);
	}
	if( Definition != (def *)0 ) 
	    for( a = 1; a <= NrPcGens; a++ )
		if( (h = Definition[a].h) > (gen)0 ) {
		    nrNewGens--;
		    if( (g = Definition[a].g) == (gen)0 )
			Power[h] = (word)((unsigned long)Power[h] | MARK);
		    else
			Conjugate[h][g] =
			    (word)((unsigned long)Conjugate[h][g] | MARK);
		}

/*	printf( "Nr of new generators: %d\n", nrNewGens ); */
	/* Extend the arrays Exponent[], Power[], Definition[],
	** Conjugate[] and Commute[].
	** Also PcGenName[] so that the presentation can be printed.     */
	Exponent =
	    (exp *)ReAllocate( Exponent,(NrPcGens+nrNewGens+1)*sizeof(exp) );
	for( h = NrPcGens+1; h <= NrPcGens+nrNewGens; h++ )
	    Exponent[h] = (exp)0;
	PcGenName =
	    (char **)ReAllocate(PcGenName,(NrPcGens+nrNewGens+1)*sizeof(char*));
	for( h = NrPcGens+1; h <= NrPcGens+nrNewGens; h++ ) {
	    int ndigs = 0, n = h-NrPcGens;
	    while( n != 0 ) { ndigs++; n /= 10; };
	    PcGenName[h] = (char *)Allocate((ndigs+2)*sizeof(char));
	    sprintf( PcGenName[h], "#%d", h-NrPcGens );
	}

	Power =
	    (word *)ReAllocate( Power,(NrPcGens+nrNewGens+1)*sizeof(word) );
	for( h = NrPcGens+1; h <= NrPcGens+nrNewGens; h++ )
	    Power[h] = (word)0;

	if( Definition != (def *)0 )
	    Definition =
	     (def *)ReAllocate(Definition,(NrPcGens+nrNewGens+1)*sizeof(def));
	else
	    Definition = (def *)Allocate( (NrPcGens+nrNewGens+1)*sizeof(def));

	NewConj =
	    (word **)Allocate( (2*(NrPcGens+nrNewGens)+1)*sizeof(word *) );
	NewConj += NrPcGens+nrNewGens;
	if( Conjugate != (word **)0 ) {
	    for( h = -NrPcGens; h <= NrPcGens; h++ )
		if( h != 0 ) NewConj[h] = Conjugate[h];
	    Free( Conjugate-NrPcGens );
	}
	Conjugate = NewConj;

	Commute =
	    (gen *)ReAllocate( Commute,(NrPcGens+nrNewGens+1)*sizeof(gen) );

	/* Define a new generator for each non-defining power relation. */
	for( a = 1; a <= NrPcGens; a++ )
	    if( Exponent[a] != 0 )
		if( !((unsigned long)Power[a] & MARK) )
		    ExtendPower( a, Power[a] );
		else
		    Power[a] = (word)((unsigned long)Power[a] & UNMARK);

	/* Define a new generator for each non-defining conjugate relation. */
	for( h = 2; h <= NrPcGens; h++ ) {
	    if( Conjugate[h] == (word *)0 ) {
		Conjugate[h] = (word *)Allocate( (2*(h-1)+1)*sizeof(word) );
		Conjugate[h] += h-1;
	    }
	    for( g = 1; g < h; g++ ) {
		if( !((unsigned long)Conjugate[h][g] & MARK) )
		    ExtendConj( h, g, Conjugate[h][g] );
		else
		    Conjugate[h][g] =
			(word)((unsigned long)Conjugate[h][g] & UNMARK);
		if( Exponent[g] == 0 )
		    if( !((unsigned long)Conjugate[h][-g] & MARK) )
			ExtendConj( h, -g, Conjugate[h][-g] );
		    else
			Conjugate[h][-g] =
			    (word)((unsigned long)Conjugate[h][-g] & UNMARK);
	    }
	}
/*	printf( "Nr of central generators: %d\n", NrCenGens ); */

	/*
	**    Now complete the presentation by recalculating Commute[].
	**    Each of the old generators commutes precisely with all new
	**    generators.
	*/
	for( g = 1; g <= NrPcGens; g++ ) Commute[g] = NrPcGens;
	for( ; g <= NrPcGens+NrCenGens; g++ ) Commute[g] = g;
}

IsNormal( w )
word	w;

{	if( Exponent[w->g] > 0 )
	    if( w->e <= 0 || w->e >= Exponent[w->g] ) return 0;
	
	w++;
	while( w->g != EOW ) {
	    if( w->g <= (w-1)->g ) return 0;
	    if( Exponent[w->g] > 0 )
		if( w->e <= 0 || w->e >= Exponent[w->g] ) return 0;
	    w++;
	}
	return 1;
}

