/****************************************************************************
**
**    schur.c                        PC                        Werner Nickel
**
**    Copyright 1992                            Mathematics Research Section
**                                           School of Mathematical Sciences 
**                                            Australian National University
*/

#include "presentation.h"
#include "pc.h"

#include "/usr/local/include/gmp.h"
typedef	MP_INT	large;
typedef large	*lvec;

#include <sys/time.h>
#include <sys/resource.h>

long	runTime() {

	struct	rusage	buf;

	if( getrusage( RUSAGE_SELF, &buf ) ) {
		perror( "couldn't obtain timing" );
		exit( 1 );
	}
	return buf.ru_utime.tv_sec*1000 + buf.ru_utime.tv_usec/1000;
}

void	AddRow( tmp, whence, c, b, a )
void	*tmp;
int	whence;
gen	c, b, a;


{       long	h, i, j;
	lvec   	v, w;
	expvec	ev = tmp;
	
/*	PrintConCheck( whence, c, b, a );
	printf( "   " );
	for( i = 1; i <= NrPcGens+NrCenGens; i++ )
	    printf( " %d", ev[i] );
	printf( "\n" );
*/

	/* Check if the first NrPcGens entries in the exponent vector
	** are zero. */
	for( i = 1; i <= NrPcGens; i++ ) {
	    if( ev[i] != 0 ) {
		printf( "Warning, exponent vector is not a tail in " );
		PrintConCheck( whence, c, b, a );
		printf( ".\n" );
	    }
	}

	/* Find the head, i.e. the first non-zero entry, of ev. */
	for( h = 1; h <= NrCenGens && ev[NrPcGens+h] == 0; h++ )
	    ;

	/* If ev is the null vector, return. */
	if( h > NrCenGens ) return;

	/* Copy the last NrCenGens entries of ev, the imd package
	** addresses vectors starting from 0.                     */
	v = (lvec)Allocate( NrCenGens*sizeof(large) );
	for( i = 1; i <= NrCenGens; i++ )
	    mpz_init_set_si( &v[i-1], ev[NrPcGens+i] );

	AppendRow( v );
}

main( argc, argv )
int	argc;
char	*argv[];

{	FILE	*fp;
	char	*filename;
	int	i, n;
	lvec	elemDiv;
        extern  ImtTime, ImdTime;

	if( argc == 1 ) {
	    fp = stdin;
	    filename = "<stdin>";
	}
	else if( argc == 2 ) {
	    filename = argv[1];
	    if( (fp = fopen( filename, "r" )) == NULL ) {
		perror( filename );
		exit( 1 );
	    }
	}
	else {
	    fprintf( stderr, "usage: schur [<file>]\n" );
	    exit( 1 );
	}

	ReadPcPres( fp, filename );

/*	if( !IsFinite ) { printf( "Group must be finite.\n" ); exit( 27 ); }*/

/*	PrintPcPres();*/
/*	Consistency( (void (*)())0, 0 );*/
/*	printf( "Defining new generators.\n" );*/
	ExtendPcPres();
/*	PrintPcPres();*/

	InitIMT( NrCenGens );
	Consistency( AddRow, 1 );
/*	PrintMatrix();
*/	InitIMD( 0, 0 );
	RunImd();
/*	PrintMatrix();
*/
	elemDiv = (lvec)Allocate( NrCenGens*sizeof(large) );
	n = ElemDivisors( elemDiv );

	if( n > 0 ) {
	    printf( "The Schur multiplicator is C_" );
	    mpz_out_str( stdout, 10, &elemDiv[0] );
	    for( i = 1; i < n; i++ ) {
		printf( " x C_" );
		mpz_out_str( stdout, 10, &elemDiv[i] );
	    }
	    printf( ".\n" );
	}
	else
	    printf( "The Schur multiplicator is trivial.\n" );

	printf( "The computation took %d msec.\n", runTime() );
        printf( "Time spent on integer matrix:\n" );
        printf( "Imt: %d    Imd: %d\n", ImtTime, ImdTime );

	return 0;
}
