/****************************************************************************
**
**    relations.c                     PC                       Werner Nickel
**
**    Copyright 1992                            Mathematics Research Section
**                                           School of Mathematical Sciences 
**                                            Australian National University
*/

#include "presentation.h"
#include "pc.h"

word	*Map = (word *)0;
int	NrImages = 0;

void	evalRelations( processRelation )
void	(*processRelation)();

{	node	*r;
	word	w;

	r = FirstRelation();
	while( r != (node *)0 ) {
	    w = (word)EvalNode( r );
	    processRelation( w );
	    r = NextRelation();
	}
}

void	printMap() {

	gen	g;

	if( Map == (word *)0 ) {
	    fprintf( stderr, "No map set." );
	    return;
	}

	for( g = 1; g <= NrImages; g++ ) {
	    printf( "    %s |---> ", GenName(g) );
	    WordPrint( Map[g] );
	    putchar( '\n' );
	}
}
