#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "pid-job.h"
#include "file-name.h"

int
getmpqsjob()
{
	char	buf[BUFSIZ];
	char	pid_jobname[BUFSIZ];
	FILE	*pid_jobfp;

	buildfilename(pid_jobname, PIDDIR, MPQS_PID, NULL);

	if ((pid_jobfp = fopen(pid_jobname, "r")) == NULL) {
		fprintf(stderr, "Cannot open %s\n", pid_jobname);
		return 0;
	}

	while (fgets(buf, sizeof buf, pid_jobfp)) {
		int	job;
		if (strncmp(buf, "job ", 4) == 0) {
			job = atoi(buf + 4);
			fclose(pid_jobfp);
			return job;
		}
	}
	fclose(pid_jobfp);
	return 0;
}

int
getmpqspid()
{
	char	buf[BUFSIZ];
	char	pid_jobname[BUFSIZ];
	FILE	*pid_jobfp;

	buildfilename(pid_jobname, PIDDIR, MPQS_PID, NULL);

	if ((pid_jobfp = fopen(pid_jobname, "r")) == NULL) {
		return 0;
	}

	while (fgets(buf, sizeof buf, pid_jobfp)) {
		int	pid;
		if (strncmp(buf, "pid ", 4) == 0) {
			pid = atoi(buf + 4);
			fclose(pid_jobfp);
			return pid;
		}
	}
	fclose(pid_jobfp);
	return 0;
}

/*
 *	return	uid of the pid-job file if it exists,
 *	otherwise, return -1;
 */
short
getmpqsuid()
{
	char	pid_jobname[BUFSIZ];
	struct	stat	statbuf;

	buildfilename(pid_jobname, PIDDIR, MPQS_PID, NULL);

	if (stat(pid_jobname, &statbuf) == -1) {
		return -1;
	} else {
		return statbuf.st_uid;
	}
}

getrunfactorpid()
{
    char	buf[BUFSIZ];
    char	pid_jobname[BUFSIZ];
    FILE	*pid_jobfp;
    
    buildfilename(pid_jobname, PIDDIR, RUN_PID, NULL);
    
    if ((pid_jobfp = fopen(pid_jobname, "r")) == NULL) {
	return 0;
    }
    
    while (fgets(buf, sizeof buf, pid_jobfp)) {
	int	pid;
	if (strncmp(buf, "pid ", 4) == 0) {
	    pid = atoi(buf + 4);
	    fclose(pid_jobfp);
	    return pid;
	}
    }
    fclose(pid_jobfp);
    return 0;
}

writepid(int pid)
{
    char	pid_jobname[BUFSIZ];
    FILE	*pid_jobfp;
    
    buildfilename(pid_jobname, PIDDIR, RUN_PID, NULL);
    
    if ((pid_jobfp = fopen(pid_jobname, "w")) == NULL) {
	fprintf(stderr, "Cannot open %s\n", pid_jobname);
	return 0;
    }
    
    fprintf(pid_jobfp, "pid %d\n", pid);
    
    fclose(pid_jobfp);
    return 1;
}

writepid_job(int pid, int job)
{
	char	pid_jobname[BUFSIZ];
	FILE	*pid_jobfp;

	buildfilename(pid_jobname, PIDDIR, MPQS_PID, NULL);

	if ((pid_jobfp = fopen(pid_jobname, "w")) == NULL) {
		fprintf(stderr, "Cannot open %s\n", pid_jobname);
		return 0;
	}

	fprintf(pid_jobfp, "pid %d\n", pid);
	fprintf(pid_jobfp, "job %d\n", job);

	fclose(pid_jobfp);
#if 0
	if (chmod(pid_jobname, S_IRUSR || S_IWUSR || S_IRGRP || S_IWGRP || S_IROTH || S_IWOTH) != 0)
	{
	  fprintf(stderr,"Error in chmod.\n");
	  fflush(stdout);
	}
#endif
	return 1;
}
