#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/wait.h>
/*
 *	returns load average
 */
#include "getloadav.h"

float
getloadav()
{
	static	FILE	*loadst_fp;
	char	buffer[BUFSIZ];
	int fildes[2];
	int childid,status,ch2;
	char *t1,*t2,*t3,*loadav;

	pipe(fildes);
	switch ((childid=fork())) {
	case -1:
		fputs("Cannot fork() loadst\n", stderr);
		exit(1);
	case 0:			/* child */
		dup2(fildes[1], 1);
		close(fildes[0]);
		execl(LOADST, LOADST, 0);
		exit(1);
		break;
	default:
		close(fildes[1]);
		loadst_fp = fdopen(fildes[0], "r");
		ch2=wait(&status);
		break;
	}
	fflush(loadst_fp);
	if (fgets(buffer, sizeof buffer, loadst_fp)) {
	        t1=strchr(buffer,',');
		t2=strchr(++t1,',');
		t3=strchr(++t2,':');
		loadav=strtok(++t3,",");
		fclose(loadst_fp);
		return(atof(loadav));
	}
	fclose(loadst_fp);
	return 0;
}
