(define display-variable #f)

(define line-count 0)

(define record-of-steps ())

(define show-rule-names #t)

(define display-steps
  (lambda ()
    (if show-rule-names
        (for-each (lambda (step) (display "[")
                          (display step)
                          (display "]"))
                  (reverse record-of-steps)))))

(define line-of-first-step 0)

(define record-new-step
  (lambda name-and-tagstring
    (let ((rule-name (car name-and-tagstring)))
      (if (null? record-of-steps)
          (set! line-of-first-step line-count))
      (set! record-of-steps
            (cons
             (string-append
              rule-name
              (if (null? (cdr name-and-tagstring))
                  ""
                  (string-append ": " (cadr name-and-tagstring))))
             record-of-steps)))))

(define record-step
  (lambda name-and-tagsymbol
    (let ((rule-name (car name-and-tagsymbol)))
      (if (null? (cdr name-and-tagsymbol))
          (record-new-step rule-name)
          (let ((tag-string  (symbol->string (cadr name-and-tagsymbol))))
            (if (same-previous-step? rule-name)
                (merge-into-step tag-string)
                (record-new-step rule-name tag-string)))))))

(define display-reductions
  (lambda exp-and-flag
    (cond ((or (pair? record-of-steps)
               (pair? (cdr exp-and-flag)))
           (newline)
           (display "==(")
           (display (number->string line-of-first-step))
           (display ")")
           (display-steps)
           (display "==>")
           (newline)
           (pp (car exp-and-flag))
           (newline)))
    (set! record-of-steps '())))

(define (merge-into-step tag-string)
  (set-car!
   record-of-steps
   (string-append
    (car record-of-steps) " " tag-string)))

(define (same-previous-step? rule-name)
  (and (pair? record-of-steps)
       (> (string-length (car record-of-steps)) (string-length rule-name))
       (string=? (string-append rule-name ":")
                 (string-head
                  (car record-of-steps)
                  (1+ (string-length rule-name))))))


