(define (rec-factorial n) (if (<= n 0) 1 (* n (rec-factorial (- n 1)))))

(rec-factorial 2)

(define (iter-factorial n)
  (letrec ((iter (lambda (n result)
                   (if (<= n 0)
                       result
                       (iter (- n 1) (* n result))))))
    (iter n 1)))

(iter-factorial 2)

(define (factdef fact)
  (lambda (n) (if (<= n 0)
                  1
                  (* n (fact (- n 1))))))

(define (fact-empty n) 0)

(define fact0 (factdef fact-empty))

(define fact1 (factdef fact0))

(define fact2 (factdef fact1))

(fact2 2)

(define
 (y f)
 ((lambda (x) (f (lambda (z) ((x x) z))))
  (lambda (x) (f (lambda (z) ((x x) z))))))

(define y-fact (y factdef))

(y-fact 1)

(define (Y2 f)
  ((lambda (x) (f (lambda(z1 z2) ((x x) z1 z2))))
   (lambda (x) (f (lambda(z1 z2) ((x x) z1 z2))))))

(define (y-iter-fact n)
  ((Y2 (lambda (iter)
       (lambda (n result)
                (if (<= n 0)
                    result
                    (iter (- n 1) (* n result))))))
    n 1))

(y-iter-fact 2)

