;;reads a file of definitions, evaluates them in Scheme, and binds the
;;newly defined variables to corresponding new constants in SUB-EVAL

(define (install-system-defs filename)
    (with-input-from-file filename import-loop))

(define (import-loop)
  (let ((rd (read)))
    (cond ((eof-object? rd)
           (newline)
           (display "import done"))
          ((define? rd)
           (let ((def-var (cadr (do-define rd))))
             (eval rd user-initial-environment)
             (install-bound-variable def-var (eval def-var user-initial-environment))
             (import-loop)))
          (else (eval rd user-initial-environment)
                (import-loop)))))

(define (install-bound-variable name obj)
  (let ((bracket-name (add-angle-brackets name)))
    (add-to-functional-constants! bracket-name)
    (do-bindings name bracket-name)
    (newline)
    (display name) (display " has been defined")
    (eval `(define ,bracket-name ,(scheme->subeval obj)) user-initial-environment)))
