//$$ sort.cxx                            Sorting

// Copyright (C) 1991: R B Davies and DSIR

#define WANT_MATH

#include "include.hxx"

#include "newmatap.hxx"


/******************************** Shell sort ********************************/

void SortAscending(GeneralMatrix& GM)
{
   // from numerical recipies in C - Shell sort
   const double aln2i = 1.442695022; const double tiny = 1.0e-5;
   real* gm = GM.Store(); int n = GM.Storage(); int m = n;
   int lognb2 = (int)(aln2i * log((double)n) + tiny);
   while (lognb2--)
   {
      m >>= 1;
      for (int j = m; j<n; j++)
      {
         real* gmj = gm+j; int i = j-m; real* gmi = gmj-m; real t = *gmj;
         while (i>=0 && *gmi>t)  { *gmj = *gmi; gmj = gmi; gmi -= m; i -= m; }
         *gmj = t;
      }
   }
}

void SortDescending(GeneralMatrix& GM)
{
   // from numerical recipies in C - Shell sort
   const double aln2i = 1.442695022; const double tiny = 1.0e-5;
   real* gm = GM.Store(); int n = GM.Storage(); int m = n;
   int lognb2 = (int)(aln2i * log((double)n) + tiny);
   while (lognb2--)
   {
      m >>= 1;
      for (int j = m; j<n; j++)
      {
         real* gmj = gm+j; int i = j-m; real* gmi = gmj-m; real t = *gmj;
         while (i>=0 && *gmi<t)  { *gmj = *gmi; gmj = gmi; gmi -= m; i -= m; }
         *gmj = t;
      }
   }
}

