//$$ include.hxx         include files required by various versions of C++

//#define Glock                         // for Glockenspiel on the PC
//#define ATandT                        // for AT&T C++ on a Sun
//#define GXX                           // for Gnu C++


#define USING_DOUBLE                    // elements of type double
//#define USING_FLOAT                   // elements of type float



#ifdef __ZTC__                          // Zortech
   #include <stdlib.h>
   #ifdef WANT_STREAM
      #include <stream.hpp>
      #define flush ""                  // doesn't have io manipulators
   #endif
   #ifdef WANT_MATH
      #include <math.h>
      #include <float.h>
   #endif
#endif

#ifdef __BCPLUSPLUS__                   // Borland
   #include <stdlib.h>
   #ifdef WANT_STREAM
      #include <iostream.h>
      #include <iomanip.h>
   #endif
   #ifdef WANT_MATH
      #include <math.h>
      #define SystemV                   // optional in Borland
      #include <values.h>               // Borland has both float and values
   #endif
   #undef __TURBOC__                    // also defined in Borland
#endif

#ifdef __TURBOC__                       // Turbo
   #include <stdlib.h>
   #ifdef WANT_STREAM
      #include <iostream.h>
      #include <iomanip.h>
   #endif
   #ifdef WANT_MATH
      #include <math.h>
      #define SystemV                   // optional in Turbo
      #include <values.h>
   #endif
#endif

#ifdef ATandT                           // AT&T
#include <stdlib.h>
#ifdef WANT_STREAM
#include <iostream.h>
#include <iomanip.h>
#endif
#ifdef WANT_MATH
#include <math.h>
#define SystemV                         // must use System V on my Sun
#include <values.h>                     //    as float.h is not present
#endif
#endif

#ifdef GXX                              // Gnu C++
   #include <stdlib.h>
   #ifdef WANT_STREAM
      #include <stream.h>               // no iomanip in G++
      #define flush ""
   #endif
   #ifdef WANT_MATH
      #include <math.h>
      #include <float.h>
   #endif
#endif

#ifdef Glock                            // Glockenspiel
   extern "C" { #include <stdlib.h> }
   #ifdef WANT_STREAM
      #include <stream.hxx>
      #include <iomanip.hxx>
   #endif
   #ifdef WANT_MATH
      extern "C" { #include <math.h> }
      extern "C" { #include <float.h> }
   #endif
   #define NO_LONG_NAMES                // very long names don't work
#endif



#ifdef USING_FLOAT                      // set precision type to float
typedef float real;
typedef double long_real;
#endif

#ifdef USING_DOUBLE                     // set precision type to double
typedef double real;
typedef long double long_real;
#endif
