/*
 *	Operator definitions for <A>GEMatrix
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)xgematop.cc	2.2	9/18/89
 */

#define NO_VECTOR_MATHFUN
#include "rw/<A>GEMatrix.h"
#define TYPE <T>_TYPE
#include "vecdefs.h"

// g++ bug requires this:
#if defined(__GNUG__) && TYPE==Float_TYPE
#include "rw/DoubleVec.h"
#endif

static const char SCCSid[] = "@(#)xgematop.cc	2.2 9/18/89";

/******** Arithmetic assignment operators **********/

<A>GEMatrix&
<A>GEMatrix::operator+=(const <A>GEMatrix& m)
{
  assertRowCol(m);
  <T>Vec::operator+=(m);
  return *this;
}

<A>GEMatrix&
<A>GEMatrix::operator+=(<T> s)
{
  <T>Vec::operator+=(s);
  return *this;
}
<A>GEMatrix&
<A>GEMatrix::operator-=(const <A>GEMatrix& m)
{
  assertRowCol(m);
  <T>Vec::operator-=(m);
  return *this;
}

<A>GEMatrix&
<A>GEMatrix::operator-=(<T> s)
{
  <T>Vec::operator-=(s);
  return *this;
}
<A>GEMatrix&
<A>GEMatrix::operator*=(const <A>GEMatrix& m)
{
  assertRowCol(m);
  <T>Vec::operator*=(m);
  return *this;
}

<A>GEMatrix&
<A>GEMatrix::operator*=(<T> s)
{
  <T>Vec::operator*=(s);
  return *this;
}

#if HAS_DIVIDE
<A>GEMatrix&
<A>GEMatrix::operator/=(const <A>GEMatrix& m)
{
  assertRowCol(m);
  <T>Vec::operator/=(m);
  return *this;
}

<A>GEMatrix&
<A>GEMatrix::operator/=(<T> s)
{
  <T>Vec::operator/=(s);
  return *this;
}
#endif

/******** Increment / Decrement operators **********/

#if HAS_INCRDECR
<A>GEMatrix&
<A>GEMatrix::operator++()
{
  <T>Vec::operator++();
  return *this;
}

<A>GEMatrix&
<A>GEMatrix::operator--()
{
  <T>Vec::operator--();
  return *this;
}
#endif

/******** Arithmetic operators *****************/

// This macro recasts m, which is a <A>GEMatrix, as a <T>Vec:
#define BASE(m) (*((<T>Vec*)&(m)))

// Unary minus
<A>GEMatrix
operator-(const <A>GEMatrix& m)
{
  return <A>GEMatrix(-BASE(m), m.rows(), m.cols());
}

<A>GEMatrix
operator*(const <A>GEMatrix& m1, const <A>GEMatrix& m2)
{
  m1.assertRowCol(m2);
  return <A>GEMatrix( BASE(m1) * BASE(m2), m1.rows(), m1.cols());
}

#if HAS_DIVIDE
<A>GEMatrix
operator/(const <A>GEMatrix& m1, const <A>GEMatrix& m2)
{
  m1.assertRowCol(m2);
  return <A>GEMatrix( BASE(m1) / BASE(m2), m1.rows(), m1.cols());
}
#endif

<A>GEMatrix
operator+(const <A>GEMatrix& m1, const <A>GEMatrix& m2)
{
  m1.assertRowCol(m2);
  return <A>GEMatrix( BASE(m1) + BASE(m2), m1.rows(), m1.cols());
}

<A>GEMatrix
operator-(const <A>GEMatrix& m1, const <A>GEMatrix& m2)
{
  m1.assertRowCol(m2);
  return <A>GEMatrix( BASE(m1) - BASE(m2), m1.rows(), m1.cols());
}

// g++ bug requires the generation of an
// explicit temporary in what follows:

<A>GEMatrix
operator*(const <A>GEMatrix& m, <T> s)
{
  <T>Vec temp = BASE(m) * s;
  return <A>GEMatrix( temp, m.rows(), m.cols());
}

#if HAS_DIVIDE
<A>GEMatrix
operator/(const <A>GEMatrix& m, <T> s)
{
  <T>Vec temp = BASE(m) / s;
  return <A>GEMatrix( temp, m.rows(), m.cols());
}

<A>GEMatrix
operator/(<T> s, const <A>GEMatrix& m)
{
  <T>Vec temp = s / BASE(m);
  return <A>GEMatrix( temp, m.rows(), m.cols());
}
#endif

<A>GEMatrix
operator+(const <A>GEMatrix& m, <T> s)
{
  <T>Vec temp = BASE(m) + s;
  return <A>GEMatrix( temp, m.rows(), m.cols());
}

<A>GEMatrix
operator-(const <A>GEMatrix& m, <T> s)
{
  <T>Vec temp = BASE(m) - s;
  return <A>GEMatrix( temp, m.rows(), m.cols());
}

<A>GEMatrix
operator-(<T> s, const <A>GEMatrix& m)
{
  <T>Vec temp = s - BASE(m);
  return <A>GEMatrix( temp, m.rows(), m.cols());
}
