/*
 *	Test math functions
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)testmath.cc	2.2	9/18/89
 */


#include "rw/DComplexVec.h"

#define ORDER 10

void checkroots(const DComplexVec&);

main()
{
  cout << "Testing roots of one.\n";
  cout << "Check values should be within machine precision of Complex(1,0).\n";
  cout << "\n***** Roots of one of order " << ORDER<<NL;
  DComplexVec plusroots = rootsOfOne(ORDER);
  checkroots(plusroots);

  cout << "\n***** Roots of one of order " << -ORDER<<NL;
  DComplexVec minusroots = rootsOfOne(-ORDER);
  checkroots(minusroots);

  cout << "\n***** Program should now exit with error.\n";
  DComplexVec impossible = rootsOfOne(0);
}

void
checkroots(const DComplexVec& roots)
{
  int order = roots.length();

  // Check each root
  for(int i = 0; i < order; i++){
    DComplex prod = pow(roots(i), order);
    cout << "Root " << i << ": " << roots(i) <<
      "; Check value: "<<prod<<NL;
  }
}
