/*
 *	Type specific routines for FloatVec
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)fvecx.cc	2.2	9/18/89
 */


#define NO_VECTOR_MATHFUN
#include "rw/FloatVec.h"
#include "rw/DoubleVec.h"

static const char SCCSid[] = "@(#)fvecx.cc	2.2 9/18/89";

// Construct from DoubleVec     
FloatVec::FloatVec(const DoubleVec& v)
{
  register int n = npts = v.length();
  block = new FloatBlock(n);
  register float* tp = begin = block->data();
  register double* dp = v.data();
  register int ds = v.stride();
  while(n--){
    *tp++ = float(*dp); dp += ds;
  }
  step = 1;
}

// Convert to DoubleVec.  
// Should be a friend, but.... 
FloatVec::operator DoubleVec()
{
  register int n = length();
  DoubleVec temp(n);
  register double* dp = temp.data();
  register float* tp = data();
  register int ts = stride();
  while(n--) {
    *dp++ = double(*tp); tp += ts;
  }
  return temp;
}
