/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _win_panel.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#include <LEDA/window.h>
#include "x_draw.h"


//------------------------------------------------------------------------------
//   PANELS
//------------------------------------------------------------------------------


panel::panel()  
{ panel_ptr = x_draw_panel_create(); 
  x_draw_panel_label(panel_ptr,""); 
  }

panel::panel(string s) 
{ panel_ptr = x_draw_panel_create(); 
  x_draw_panel_label(panel_ptr,~s); 
 }

panel::~panel() 
{ x_draw_panel_destroy(panel_ptr); }


void panel::label(string s)       
{ x_draw_panel_label(panel_ptr,~s); }

void panel::text_item(string s)   
{ x_draw_panel_text_item(panel_ptr,~s); }

void panel::int_item(string s,int& x) 
{ x_draw_panel_int_item(panel_ptr,~s,&x);}

void panel::int_item(string s,int& x, int l, int h) 
{ x_draw_panel_slider_item(panel_ptr,~s,&x,l,h);}

void panel::double_item(string s, double& x) 
{ x_draw_panel_float_item(panel_ptr,~s,&x);}

void panel::real_item(string s, double& x)
{ x_draw_panel_float_item(panel_ptr,~s,&x); }

void panel::string_item(string s, string& x)
{ x = ~x;
  x_draw_panel_string_item(panel_ptr,~s,x.cstring());
 }

void  panel::string_item(string label,string& x,list(string)& L)
{ x = ~x;  // disconnect
 char** p = new char*[L.length()];
 int    i = 0;
 string s;
 forall(s,L) 
    if (s.length() > 0) p[i++] = ~s;
 x_draw_panel_string_menu_item(panel_ptr,~label,x.cstring(),"",i,p); 
}


void panel::new_button_line(list(string)& L)
{ char** p = new char*[L.length()];
  int i=0;
  string s;
  forall(s,L) p[i++] = ~s;
  x_draw_panel_button_line(panel_ptr,i,p);
 }

int  panel::open(window& W) { return open(W,-1,-1); }

int  panel::open(window&, int x, int y)
{ if (x_draw_grid_mode) x_draw_cursor();
  int button = x_draw_panel_open(panel_ptr,x,y, x_draw_window_xpos, 
                                                x_draw_window_ypos,
                                                x_draw_window_width,
                                                x_draw_window_height);
  if (x_draw_grid_mode) x_draw_cursor();
  return button;
 }

int  panel::open() { return open(-1,-1); }

int  panel::open(int x, int y)
{ if (x_draw_grid_mode) x_draw_cursor();
  int button = x_draw_panel_open(panel_ptr,x,y,0,0,0,0);
  if (x_draw_grid_mode) x_draw_cursor();
  return button;
 }

void  panel::choice_item(string label,int& x,list(string)& L)
{ char** p = new char*[L.length()];
  int    i = 0;
  string s;
  forall(s,L) p[i++] = ~s;
  x_draw_panel_choice_item(panel_ptr,~label,&x,i,p,1,0); 
  delete p;
}

void  panel::choice_item(string header,int& x,string s1, string s2)
{ char** p = new char*[2];
  p[0] = ~s1;
  p[1] = ~s2;
  x_draw_panel_choice_item(panel_ptr,~header,&x,2,p,1,0);
  delete p;
 }

void  panel::choice_item(string header,int& x,string s1, string s2, string s3)
{ char** p = new char*[3];
  p[0] = ~s1;
  p[1] = ~s2;
  p[2] = ~s3;
  x_draw_panel_choice_item(panel_ptr,~header,&x,3,p,1,0);
  delete p;
 }

void  panel::choice_item(string header,int& x,string s1, string s2, string s3, string s4)
{ char** p = new char*[4];
  p[0] = ~s1;
  p[1] = ~s2;
  p[2] = ~s3;
  p[3] = ~s4;
  x_draw_panel_choice_item(panel_ptr,~header,&x,4,p,1,0);
  delete p;
 }

void  panel::choice_item(string header,int& x,string s1, string s2, string s3, string s4, string s5)
{ char** p = new char*[5];
  p[0] = ~s1;
  p[1] = ~s2;
  p[2] = ~s3;
  p[3] = ~s4;
  p[4] = ~s5;
  x_draw_panel_choice_item(panel_ptr,~header,&x,5,p,1,0);
  delete p;
 }


void panel::int_item(string s,int& x,int low, int high, int step)   
{ int n = high -low;
  n = n/step +1;
  char** p = new char*[n];
  for(int i = 0; i < n; i++) p[i] = ~string("%d",low+i*step);
  x_draw_panel_choice_item(panel_ptr,~s,&x,n,p,step,low);
  delete p;
 }

void panel::bool_item(string s, int& x)
{ char** p = new char*[2];
  p[0] = "off";
  p[1] = "on";
  x_draw_panel_choice_item(panel_ptr,~s,&x,2,p,1,0);
  delete p;
 }

void panel::color_item(string s, color& x)
{ int n = 6;
  char** p = new char*[6];

  p[0] = "white";
  p[1] = "black";
  p[2] = "red";
  p[3] = "green";
  p[4] = "blue";
  p[5] = "yellow";

  if (x_draw_depth==1) 
  { n = 2;
    if (x!=white) x = black;
  }

  x_draw_panel_choice_item(panel_ptr,~s,(int*)&x,n,p,1,0);

  delete p;
 }

void panel::lstyle_item(string s, line_style& x)
{ char** p = new char*[3];

  p[0] = "solid";
  p[1] = "dashed";
  p[2] = "dotted";

  x_draw_panel_choice_item(panel_ptr,~s,(int*)&x,3,p,1,0);
  delete p;
 }


// buttons:

void panel::button(string s)             
{ x_draw_panel_button(panel_ptr,~s); }


void panel::new_button_line()            
{ x_draw_panel_button_line(panel_ptr,0,0);  }

