/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _memory.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/basic.h>

//------------------------------------------------------------------------------
// Memory Management
//------------------------------------------------------------------------------

const int memory_word_size = 4;     // size of word  (bytes)
const int memory_block_bytes = 4092; // size of block (bytes) 2^k - 4
const int memory_block_words = 1023; // size of block (in words)
const int memory_max_size = 64;     // maximal size of structures (words)

//extern
memory_elem_ptr memory_free_list[65];     //memory_max_size + 1


static memory_elem_ptr memory_block_list[65];
static long int        memory_total_count[65]; 
static int             memory_block_count = 0;



memory_elem_ptr memory_allocate_block(int size)
{ // fills memory_free_list[size] with l new elements of size "size" 

  register memory_elem_ptr q;
  register memory_elem_ptr p;


  if ( (q=memory_elem_ptr(malloc(memory_block_bytes))) == 0 )
   { cout << string("memory_alloc: out of memory\n");
     print_statistics();
     exit(1);
    }

  memory_block_count++;

  q->next = memory_block_list[size];
  memory_block_list[size] = q;

  q++; 

  memory_free_list[size] = q;

  int l = (memory_block_words-1)/size;
  memory_total_count[size] += l;

  p = q + (l-1)*size;
  p->next = 0;

  while (q < p) q = (q->next = q+size);


/*
  // rest
  int r;
  p = p+size;
  r = memory_block_bytes%(size * memory_word_size);
  if (r = r/memory_word_size)
  { p->next = memory_free_list[r];
    memory_free_list[r] = p;
    memory_total_count[r]++;
   }
*/

 return memory_free_list[size];
}


void memory_clear()
{ 
  register memory_elem_ptr p;
  int i;
  long used;

  for (i=1;i<=memory_max_size;i++)
  { p = memory_free_list[i];
    used = memory_total_count[i];;
    while (p) { used--; p = p->next; }

    if (used==0)
    { while (memory_block_list[i])
      { p = memory_block_list[i];
        memory_block_list[i] = p->next;
        memory_block_count--;
        free((char*)p);
       }
      memory_free_list[i] = 0;
      memory_total_count[i] = 0;
     }
   }

}


void memory_kill()
{ register memory_elem_ptr p;
  int i;

  for (i=1;i<=memory_max_size;i++)
  { while (memory_block_list[i])
    { p = memory_block_list[i];
      memory_block_list[i] = p->next;
      free((char*)p);
     }
    memory_free_list[i] = 0;
    memory_total_count[i] = 0;
   }

  memory_block_count=0;

}



memory_elem_ptr allocate_words(int size)
{ memory_elem_ptr p = memory_free_list[size];
  if (p==0) p = memory_allocate_block(size);
  memory_free_list[size] = p->next;
  return p;
}

void deallocate_words(void* p, int size)
{ memory_elem_ptr(p)->next = memory_free_list[size];
  memory_free_list[size] = memory_elem_ptr(p);
 }

void deallocate_list(void* head,void* tail, int size)
{ memory_elem_ptr(tail)->next = memory_free_list[size];
  memory_free_list[size] = memory_elem_ptr(head);
 }

memory_elem_ptr Allocate_words(int size)
{ memory_elem_ptr p = memory_free_list[size];
  if (p==0) p = memory_allocate_block(size);
  memory_free_list[size] = p->next;
  cout << "Allocate   "<< int(p) << "(" << size << ")\n";
  return p;
}

void Deallocate_words(void* p, int size)
{ cout << "Deallocate  " << int(p) << "(" << size << ")\n";

  if (int(p)<=0 ) 
    error_handler(1,"deallocate: illegal pointer");  

  memory_elem_ptr(p)->next = memory_free_list[size];
  memory_free_list[size] = memory_elem_ptr(p);
}

void print_statistics()
{
  cout.flush();

  int i,size;
  long int total,free,used;
  long int total_bytes=0, free_bytes=0, used_bytes=0, b;
  char* format="     | %3d    %6ld   %6ld   %6ld   %8ld bytes |\n";     

  printf("\n");
  printf("     +--------------------------------------------------+\n");
  printf("     | size     free     used    total      space       |\n"); 
  printf("     +--------------------------------------------------+\n");

  for (i=1;i<=memory_max_size;i++)
    if ((total = memory_total_count[i]) > 0 || memory_free_list[i])
    { memory_elem_ptr p = memory_free_list[i];
      size = memory_word_size*i;
      free = 0;
      while (p) { free++; p = p->next; }
      b = total*size; 
      used  = total - free;
      free_bytes  = free_bytes  + free*size;
      used_bytes  = used_bytes  + used*size;
      total_bytes = total_bytes + b;
      printf(format,i,free,used,total,b);
     }

 printf("     +--------------------------------------------------+\n");
 printf("     | %6.2f sec          %4d blocks = %8.2f kb    |\n",
          used_time(), memory_block_count,float(total_bytes)/1024);
 printf("     +--------------------------------------------------+\n");
 printf("\n");
 fflush(stdout);

}
