
// This programs is using dictionaries with keys of type "string" with two 
// different linear orders, the lexicographic ordering  (default ordering)
// and the reversed lexicographic ordering 


#include <LEDA/dictionary.h>


int rev_cmp(const string& x, const string& y) 
{
  return compare(y,x);               // predefined compare function   
  
 }


declare(STRING,rev_cmp);


// Now "STRING(rev_cmp)" is equivalent to the data type  string
// with the linear order defined by "rev_cmp".


declare2(dictionary,string,int)           // default ordering (by compare)

declare2(dictionary,STRING(rev_cmp),int)  // ordering by rev_cmp



void main()
{
  dictionary(string,int)           D;
  dictionary(STRING(rev_cmp),int) D_rev;

  string x;

  while (cin >> x) 
  { D.insert(x,0);
    D_rev.insert(x,0);
   }

  dic_item it;

  forall_dic_items(it,D) cout << D.key(it)  << "\n";
  newline;

  forall_dic_items(it,D_rev) cout << D_rev.key(it)  << "\n";
  newline;

}
