
// Copyright 2006 Juhana Sadeharju

// sptparser: writes the spt file to an editable file.
// sptcompiler: writes the editable file to the spt file.

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>


typedef struct {
  unsigned char *buffer;
  int len;
  int n; // Current read location.
  int prevn; // Previous read location.
} ty_buffer;

int file_getsize_fd(int n)
{
  struct stat file_stats;

  if (fstat(n,&file_stats) == -1) return -1;
  return file_stats.st_size;
}

// Read the whole file to a buffer.
int file2buffer(char *s, unsigned char **buf, int *len)
{
  int fd,l;
  char *b;

  *buf = NULL;
  *len = -1;

  if ((fd = open(s,O_RDONLY)) == -1) {
    fprintf(stderr,"file2buffer: could not open file %s\n",s);
    return 0;
  }
  l = file_getsize_fd(fd);
  b = (unsigned char *)malloc((l+10)*sizeof(unsigned char));
  if (read(fd,b,l) != l) {
    fprintf(stderr,"file2buffer: could not read file %s\n",s);
    free(b);
    return 0;
  }
  close(fd);
  b[l] = '\0';
  *len = l;
  *buf = b;
  return 1;
}

ty_buffer *buffer_new(unsigned char *buffer, int len)
{
  ty_buffer *p;

  p = (ty_buffer *)malloc(sizeof(ty_buffer));
  p->buffer = buffer;
  p->len = len;
  p->n = 0;
  p->prevn = -1;
  return p;
}

int buffer_find_string(ty_buffer *p, char *s)
{
  int i,j,k,slen;

  slen = strlen(s);
  for(i = p->n; i < p->len-slen+1; i++) {
    k = 0;
    for(j = 0; j < slen; j++) {
      if (p->buffer[i+j] == s[j]) k++;
    }
    if (k == slen) {
      p->prevn = p->n;
      p->n = i;
      return i;
    }
  }
  return -1;
}

void buffer_skip_bytes(ty_buffer *p, int n)
{
  p->n += n;
}

int buffer_getn(ty_buffer *p)
{
  return p->n;
}

void buffer_setn(ty_buffer *p, int n)
{
  p->n = n;
}

char buffer_read_char(ty_buffer *p)
{
  char c;

  c = p->buffer[p->n];
  p->n++;

  return c;
}

unsigned char buffer_read_uchar(ty_buffer *p)
{
  unsigned char c;

  c = p->buffer[p->n];
  p->n++;
  // fprintf(stderr,"uchar = %i\n",(int)c);

  return c;
}

#if 0
int buffer_read_int(ty_buffer *p)
{
  unsigned char a[4];

  if (p->n >= p->len + 4) {
    fprintf(stderr,"EOF approaching too soon\n");
    exit(-1);
  }
  a[0] = buffer_read_uchar(p);
  a[1] = buffer_read_uchar(p);
  a[2] = buffer_read_uchar(p);
  a[3] = buffer_read_uchar(p);

  return ((int *)a)[0];
}

int buffer_read_short(ty_buffer *p)
{
  unsigned char a[4];

  a[0] = buffer_read_uchar(p);
  a[1] = buffer_read_uchar(p);
  a[2] = 0;
  a[3] = 0;

  return ((int *)a)[0];
}

int buffer_read_byte(ty_buffer *p)
{
  unsigned char a[4];

  a[0] = buffer_read_uchar(p);
  a[1] = 0;
  a[2] = 0;
  a[3] = 0;

  return ((int *)a)[0];
}
#endif

int buffer_read_int(ty_buffer *p)
{
  int n;

  if (p->n >= p->len + 4) {
    fprintf(stderr,"EOF approaching too soon\n");
    exit(-1);
  }
  ((unsigned char *)(&n))[0] = buffer_read_uchar(p);
  ((unsigned char *)(&n))[1] = buffer_read_uchar(p);
  ((unsigned char *)(&n))[2] = buffer_read_uchar(p);
  ((unsigned char *)(&n))[3] = buffer_read_uchar(p);

  // fprintf(stderr,"int = %i\n",n);
  printf("int = %i\n",n);
  return n;
}

int buffer_read_int_noprint(ty_buffer *p)
{
  int n;

  if (p->n >= p->len + 4) {
    fprintf(stderr,"EOF approaching too soon\n");
    exit(-1);
  }
  ((unsigned char *)(&n))[0] = buffer_read_uchar(p);
  ((unsigned char *)(&n))[1] = buffer_read_uchar(p);
  ((unsigned char *)(&n))[2] = buffer_read_uchar(p);
  ((unsigned char *)(&n))[3] = buffer_read_uchar(p);

  // fprintf(stderr,"int = %i\n",n);
  return n;
}

int buffer_read_short(ty_buffer *p)
{
  int n;

  ((unsigned char *)(&n))[0] = buffer_read_uchar(p);
  ((unsigned char *)(&n))[1] = buffer_read_uchar(p);
  ((unsigned char *)(&n))[2] = 0;
  ((unsigned char *)(&n))[3] = 0;

  // fprintf(stderr,"short = %i\n",n);
  printf("short = %i\n",n);
  return n;
}

int buffer_read_byte(ty_buffer *p)
{
  int n;

  ((unsigned char *)(&n))[0] = buffer_read_uchar(p);
  ((unsigned char *)(&n))[1] = 0;
  ((unsigned char *)(&n))[2] = 0;
  ((unsigned char *)(&n))[3] = 0;

  // fprintf(stderr,"byte = %i\n",n);
  printf("byte = %i\n",n);
  return n;
}


#if 0
// Does not work. Why?
float buffer_read_float(ty_buffer *p)
{
  unsigned char a[4];
  float *fp;
  float f;

  a[0] = buffer_read_uchar(p);
  a[1] = buffer_read_uchar(p);
  a[2] = buffer_read_uchar(p);
  a[3] = buffer_read_uchar(p);
  // fprintf(stderr,"a[] = %i, %i, %i, %i\n",(int)a[0],(int)a[1],(int)a[2],(int)a[3]);

  fp = (float *)(&(a[0]));
  f = fp[0];
  // fprintf(stderr,"float = %.40f\n",f);
  return f;
}
#endif


// How to fix the float accuracy problem?
// Now we need to print too many decimals.
float buffer_read_float(ty_buffer *p)
{
  float f;

  ((unsigned char *)(&f))[0] = buffer_read_uchar(p);
  ((unsigned char *)(&f))[1] = buffer_read_uchar(p);
  ((unsigned char *)(&f))[2] = buffer_read_uchar(p);
  ((unsigned char *)(&f))[3] = buffer_read_uchar(p);

  // fprintf(stderr,"float = %f\n",f);
  printf("float = %.16f\n",f);
  return f;
}


int buffer_eof(ty_buffer *p)
{
  if (p->n == p->len) return 1;
  return 0;
}

char *extractstring(ty_buffer *p)
{
  int i,n;
  char *s;

  n = buffer_read_int_noprint(p);
  // fprintf(stderr,"string len = %i\n",n);

  s = (char *)malloc((n+1)*sizeof(char));
  for (i = 0; i < n; i++) {
    s[i] = buffer_read_char(p);
  }
  s[n] = '\0';

  // fprintf(stderr,"string = %s\n",s);
  printf("string = \"%s\"\n",s);
  return s;
}

int main(int ac, char **av)
{
  unsigned char *buffer;
  int len,n,i;
  ty_buffer *b;
  char *s;
  float f;
  int hierarchy;

  if (ac < 2) {
    fprintf(stderr,"Usage: sptparser <file>\n");
    exit(-1);
  }

  file2buffer(av[1],&buffer,&len);

  b = buffer_new(buffer,len);

  hierarchy = 0;
  while (buffer_eof(b) != 1) {
    // Section number.
    n = buffer_read_int_noprint(b);
#if 0
    for (i = 0; i < hierarchy; i++) {
      fprintf(stderr,"  ");
    }
    fprintf(stderr,"Section = %i\n",n);
    // fprintf(stderr,"Section = %i in %s\n",n,av[1]);
#endif

    printf("section = %i\n",n);
    switch (n) {
    case 1000:
      s = extractstring(b);
      free(s);
      break;
    case 1001:
      break;
    case 1002:
      hierarchy++;
      break;
    case 1003:
      hierarchy--;
      break;
    case 1004:
      hierarchy++;
      break;
    case 1005:
      hierarchy--;
      break;
    case 1006:
      n = buffer_read_int(b);
      break;
    case 1007:
      hierarchy++;
      break;
    case 1008:
      hierarchy--;
      break;
    case 1009:
      hierarchy++;
      break;
    case 1010:
      hierarchy--;
      break;
    case 1011:
      hierarchy++;
      break;
    case 1012:
      hierarchy--;
      break;
    case 1013:
      // XXXX
      break;
    case 1014:
      n = buffer_read_int(b);
      hierarchy++;
      break;
    case 1015:
      hierarchy--;
      break;
    case 1016:
      hierarchy++;
      break;
    case 1017:
      hierarchy--;
      break;
    case 2000:
      s = extractstring(b);
      free(s);
      break;
    case 2001:
      f = buffer_read_float(b);
      break;
    case 2002:
      n = buffer_read_byte(b);
      break;
    case 2003:
      f = buffer_read_float(b);
      break;
    case 2004:
      n = buffer_read_int(b);
      break;
    case 2005:
      n = buffer_read_byte(b);
      n = buffer_read_short(b);
      n = buffer_read_byte(b);
      break;
    case 2006:
      f = buffer_read_float(b);
      break;
    case 2007:
      f = buffer_read_float(b);
      break;
    case 3000:
      f = buffer_read_float(b);
      break;
    case 3001:
      n = buffer_read_int(b);
      break;
    case 3002:
      f = buffer_read_float(b);
      break;
    case 3003:
      n = buffer_read_byte(b);
      break;
    case 3004:
      f = buffer_read_float(b);
      break;
    case 3005:
      f = buffer_read_float(b);
      break;
    case 3006:
      n = buffer_read_byte(b);
      break;
    case 3007:
      f = buffer_read_float(b);
      break;
    case 3008:
      n = buffer_read_int(b);
      break;
    case 3009:
      n = buffer_read_byte(b);
      break;
    case 3010:
      f = buffer_read_float(b);
      break;
    case 4000:
      n = buffer_read_byte(b);
      break;
    case 4001:
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      break;
    case 4002:
      f = buffer_read_float(b);
      break;
    case 4003:
      s = extractstring(b);
      free(s);
      break;
    case 4004:
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      break;
    case 4005:
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      break;
    case 4006:
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      break;
    case 4007:
      f = buffer_read_float(b);
      break;
    case 5000:
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      break;
    case 5001:
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      break;
    case 5002:
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      break;
    case 5003:
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      break;
    case 5004:
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      f = buffer_read_float(b);
      break;
    case 5005:
      f = buffer_read_float(b);
      break;
    case 5006:
      n = buffer_read_byte(b);
      break;
    case 6000:
      s = extractstring(b);
      free(s);
      break;
    case 6001:
      s = extractstring(b);
      free(s);
      break;
    case 6002:
      s = extractstring(b);
      free(s);
      break;
    case 6003:
      s = extractstring(b);
      free(s);
      break;
    case 6004:
      s = extractstring(b);
      free(s);
      break;
    case 6005:
      s = extractstring(b);
      free(s);
      break;
    case 6006:
      s = extractstring(b);
      free(s);
      break;
    case 6007:
      s = extractstring(b);
      free(s);
      break;
    case 6008:
      n = buffer_read_int(b);
      break;
    case 6009:
      n = buffer_read_int(b);
      break;
    case 6010:
      f = buffer_read_float(b);
      break;
    case 6011:
      f = buffer_read_float(b);
      break;
    case 6012:
      f = buffer_read_float(b);
      break;
    case 6013:
      f = buffer_read_float(b);
      break;
    case 6014:
      f = buffer_read_float(b);
      break;
    case 6015:
      n = buffer_read_short(b);
      n = buffer_read_short(b);
      n = buffer_read_short(b);
      break;
    case 6016:
      // XXXX
      break;
    case 6017:
      s = extractstring(b);
      free(s);
      break;
    case 8000:
      hierarchy++;
      break;
    case 8001:
      hierarchy--;
      break;
    case 8002:
      n = buffer_read_int(b);
      break;
    case 8003:
      for (i = 0; i < 13; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 8004:
      n = buffer_read_int(b);
      break;
    case 8005:
      for (i = 0; i < 13; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 8006:
      f = buffer_read_float(b);
      break;
    case 8007:
      n = buffer_read_int(b);
      break;
    case 8008:
      n = buffer_read_int(b);
      break;
    case 8009:
      for (i = 0; i < 13; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 9000:
      hierarchy++;
      break;
    case 9001:
      hierarchy--;
      break;
    case 9002:
      n = buffer_read_int(b);
      break;
    case 9003:
      f = buffer_read_float(b);
      break;
    case 9004:
      f = buffer_read_float(b);
      break;
    case 9005:
      break;
    case 9006:
      break;
    case 9007:
      n = buffer_read_int(b);
      break;
    case 9008:
      f = buffer_read_float(b);
      break;
    case 9009:
      f = buffer_read_float(b);
      break;
    case 9010:
      f = buffer_read_float(b);
      break;
    case 9011:
      n = buffer_read_int(b);
      break;
    case 9012:
      f = buffer_read_float(b);
      break;
    case 9013:
      f = buffer_read_float(b);
      break;
    case 9014:
      f = buffer_read_float(b);
      break;
    case 10000:
      hierarchy++;
      break;
    case 10001:
      hierarchy--;
      break;
    case 10002:
      n = buffer_read_int(b);
      for (i = 0; i < 8*n; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 10003:
      n = buffer_read_int(b);
      for (i = 0; i < 8*n; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 10004:
      n = buffer_read_int(b);
      for (i = 0; i < 8*n; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 11000:
      hierarchy++;
      break;
    case 11001:
      hierarchy--;
      break;
    case 11002:
      n = buffer_read_int(b);
      break;
    case 12000:
      hierarchy++;
      break;
    case 12001:
      hierarchy--;
      break;
    case 12002:
      for (i = 0; i < 4; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 12003:
      for (i = 0; i < 5; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 13000:
      hierarchy++;
      break;
    case 13001:
      hierarchy--;
      break;
    case 13002:
      n = buffer_read_int(b);
      break;
    case 13003:
      n = buffer_read_int(b);
      break;
    case 13004:
      n = buffer_read_int(b);
      break;
    case 13005:
      s = extractstring(b);
      free(s);
      break;
    case 13006:
      n = buffer_read_int(b);
      break;
    case 13007:
      n = buffer_read_byte(b);
      break;
    case 13008:
      n = buffer_read_int(b);
      break;
    case 13009:
      n = buffer_read_int(b);
      break;
    case 13010:
      f = buffer_read_float(b);
      break;
    case 13011:
      f = buffer_read_float(b);
      break;
    case 13012:
      f = buffer_read_float(b);
      break;
    case 13013:
      f = buffer_read_float(b);
      break;
    case 14000:
      hierarchy++;
      break;
    case 14001:
      hierarchy--;
      break;
    case 14002:
      s = extractstring(b);
      free(s);
      break;
    case 14003:
      f = buffer_read_float(b);
      break;
    case 14004:
      f = buffer_read_float(b);
      break;
    case 14005:
      f = buffer_read_float(b);
      break;
    case 14006:
      f = buffer_read_float(b);
      break;
    case 14007:
      n = buffer_read_int(b);
      break;
    case 14008:
      n = buffer_read_int(b);
      break;
    case 15000:
      hierarchy++;
      break;
    case 15001:
      hierarchy--;
      break;
    case 15002:
      n = buffer_read_byte(b);
      break;
    case 15003:
      f = buffer_read_float(b);
      break;
    case 16000:
      hierarchy++;
      break;
    case 16001:
      hierarchy--;
      break;
    case 16002:
      f = buffer_read_float(b);
      break;
    case 16003:
      n = buffer_read_int(b);
      break;
    case 16004:
      f = buffer_read_float(b);
      break;
    case 16005:
      f = buffer_read_float(b);
      break;
    case 16006:
      f = buffer_read_float(b);
      break;
    case 16007:
      f = buffer_read_float(b);
      break;
    case 16008:
      f = buffer_read_float(b);
      break;
    case 16009:
      f = buffer_read_float(b);
      break;
    case 16010:
      f = buffer_read_float(b);
      break;
    case 16011:
      f = buffer_read_float(b);
      break;
    case 16012:
      f = buffer_read_float(b);
      break;
    case 16013:
      n = buffer_read_int(b);
      break;
    case 16014:
      f = buffer_read_float(b);
      break;
    case 18000:
      hierarchy++;
      break;
    case 18001:
      hierarchy--;
      break;
    case 18002:
      for (i = 0; i < 3; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 18003:
      for (i = 0; i < 3; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 18004:
      for (i = 0; i < 3; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 18005:
      s = extractstring(b);
      free(s);
      break;
    case 19000:
      hierarchy++;
      break;
    case 19001:
      hierarchy--;
      break;
    case 19002:
      n = buffer_read_int(b);
      break;
    case 20000:
      hierarchy++;
      break;
    case 20001:
      hierarchy--;
      break;
    case 20002:
      s = extractstring(b);
      free(s);
      break;
    case 20003:
      n = buffer_read_short(b);
      n = buffer_read_short(b);
      n = buffer_read_short(b);
      break;
    case 20004:
      // XXXX
      break;
    case 20005:
      for (i = 0; i < 8; i++) {
	f = buffer_read_float(b);
      }
      break;
    case 21000:
	f = buffer_read_float(b);
      break;
    case 21001:
	f = buffer_read_float(b);
      break;
    case 22000:
      n = buffer_read_byte(b);
      break;
    default:
      fprintf(stderr,"Unknown section %i --- %s\n",n,av[1]);
    }
  }

  return 1;
}
