.TH XYPLOT 1L "14 SEPT 92" LANL--CNLS/T13

.SH NAME
xyplot \- a program for making two dimensional graphs

.SH SYNOPSIS
.B xyplot
.RI [ options ]
.RI [ file.xy ]

.SH GENERAL INFORMATION

.I xyplot
is a program for making two dimensional graphs.  It features
automatic scaling, logarithmic axes, error bars, labels with Greek
letters, superscripts, subscripts, and special characters,
and multiple graphs on one page.

.I xyplot
reads input either from a file specified on the command line or
(if no such file is specified) from 
.I stdin
and produces a series of 
.BR plot (5)
commands that can be view with of of the standard filters.

.SH PRINTING XYPLOT OUTPUT

Supplied with 
.I xyplot
are the utilities
.I xyps,
.I xyug,
which permit the output of
.I xyplot
to be translated either to postscript or to
a stream of UNIX graphics commands.  It is 
required that these utilities be on the path.
The default output
is UNIX graphics, and these can be printed using
.TP
xyplot file.xy | lpr -g
.LP
On some systems, the '-g' option of lpr is not supported.  In that case,
the (nearly standard) 
.I psplot
can be used to create a PostScript file:
.TP
xyplot file.xy | psplot [-gxyplot.pro] > file.ps
.LP

  
To generate postscript, use
.TP
xyplot -ps file.xy > file.ps
.LP

It is also possible to generate an intermediate language using
.TP
xyplot -xyil file.xy > file.il
.LP
and the file.il can be used directly as input for "xyps" or "xyug";
this permits more flexibility (particularly for "xyps") because
the options of xyps are now available.  For example,
.TP
xyps -l file.il > file.ps
.LP
prints the graph in lanscape mode.
(See man page for further information about "xyps").

.SH VIEWING XYPLOT OUTPUT

The file can also be viewed through a window on a Sun 
or X-windows workstation by using
.TP
xyplot file.xy | display-driver
.LP
where display-driver is one of the following:
.I "xyview" 
(SunView),
or
.I "xyplay" 
in the X window environment.
It is possible that the now obsolete drivers
.I "display"
and 
.I "sunplot",
which both work only on SunWindows, are still available.

For 
.I "display", 
the plot shows up in the current window.
For
.I "sunplot",
.I "xyview", 
and
.I "xyplay",
a separate window will be created, 
and it can be moved, hidden, iconified, etc. just as ordinary
windows.

On a Tektronix or Tektronix emulator, use
.TP
	xyplot file.xy | plot -T4014
.LP

.SH USING XYPLOT

Since 
.I xyplot
is a descendent of the UNIX 
.I graph
program, it supports most of the options of that program (now,
including command line options), but it also contains many additional
features.  With just a few options it is easy to produce a simple
plot.  For a finished plot, with nice labels etc., many options may be
necessary.

In the simplest case, the input to 
.I xyplot
is a series of lines, each
line containing a pair of values. For example:

.nf
1.0   1.0
2.0   2.1
3.0   2.9
.fi

With this input, 
.I xyplot 
will produce a graph with a line connecting
all the points.  The ranges of the x and y coordinates will be chosen
automatically to include all of the data.

There are a large number of options which modify the behavior of
.I xyplot.
These options can be specified on the command line (by beginning
each option string with a '-' character) or else in
the data file by lines beginning with the '#' character (only
one option per line).  
For example, to set the x range to be 0 to 1.5, you can use
.TP
	xyplot -x 0 1.5 data.xy
.LP
or else you can write in your file
.nf
#x  0  1.5
0.0   1.0
1.0   2.0
2.0   3.0
.fi

.I xyplot
will ignore the out of range points.

There may be any number of option lines within the data file, but each
option and data value must appear on a separate line.  For most
options, such as the x and y ranges, it only makes sense to specify
the option once per graph.  If you specify it more than once the last
specification wins (this applies to command line options as well, so
that '#' options generally beat the '-' options).  There are a number
of options such as line style, plotting symbol, and error bars that
can be changed in mid-plot.  To do this simply put the option line in
the data file at the appropriate point.

.I xyplot
can place a title on the graph, labels on the x and y axes, labels
at arbitrary points, or any character as a plotting symbol.  The character
set used in all these labels is from the SLAC Unified Graphics
System.  It contains all the usual ASCII characters, greek letters,
math symbols, and some special plotting characters.  The non-ASCII
characters are specified by troff-like escape sequences.

.SH DATA STRING

.I xyplot
uses the specified "#d string" to specify what columns of data in 
a file correspoind to x value, y values, y-error values, or if 
a given column should be ignored.  For example

.nf
#d xy          default: first column x, second column y, other columns ignored
#d xye         x,y and error (equivalent to #e)
#d yx          x and y transposed (equivalent to #t)
#d y           no x data in file, (equivalent to #a)
#d x..ye       the two dots here mean to ignore second and third columns

#d0            turns off the datastring specifier
.fi

.SH ESCAPE SEQUENCES FOR SPECIAL CHARACTERS

.nf

.I Plotting symbols:

\\pl      plus sign
\\cr      cross
\\di      diamond
\\sq      square
\\oc      octagon
\\fd      fancy diamond
\\fs      fancy square
\\fx      fancy cross
\\fp      fancy plus
\\bu      burst

.I Greek Letters (upper and lower cases):

\\ga,\\gA   alpha
\\gb,\\gB   beta
\\gg,\\gG   gamma
\\gd,\\gD   delta
\\ge,\\gE   epsilon
\\gz,\\gZ   zeta
\\gy,\\gY   eta
\\gh,\\gT   theta
\\gi,\\gI   iota
\\gk,\\gK   kappa
\\gl,\\gL   lambda
\\gm,\\gM   mu
\\gn,\\gN   nu
\\gx,\\gX   xi
\\go,\\gO   omicron
\\gp,\\gP   pi
\\gr,\\gR   rho
\\gs,\\gS   sigma
\\gt,\\gT   tau
\\gu,\\gU   upsilon
\\gf,\\gF   phi
\\gc,\\gC   chi
\\gq,\\gQ   psi
\\gw,\\gW   omega

.I Special Symbols:

\\tm      times
\\di      divide
\\+-      plus or minus
\\<=      less than or equal
\\>=      greater than or equal
\\~=      approximately equal
\\n=      not equal
\\pt      proportional to
\\is      integral sign
\\li      line integral
\\pd      partial derivative
\\dl      del (gradient)
\\sr      square root
\\ul      underline
\\rn      overbar ("run")

\\hb      h bar
\\lb      lambda bar
\\de      degree
\\in      infinity
\\dg      dagger
\\dd      double dagger
\\<-      left arrow
\\->      right arrow
\\da      down arrow
\\ua      up arrow
\\la      left angle
\\ra      right angle
\\ib      interabang
\\sc      section

\\ca      cap (intersection)
\\cu      cup (union)
\\mo      member of
\\nm      not a member of
\\ex      exists
\\al      for all
\\sb      subset
\\ds      direct sum (xor)
\\dp      direct product
\\sp      superset

.I Control Characters

\\sp      start superscript
\\ep      end superscript
\\sb      start subscript
\\eb      end subscript
\\mk      mark location
\\rt      return to mark
.fi

.SH SUMMARY OF OPTIONS

Most of these options can also be invoked on the command line;
in this case, use "-" instead of "#"

.nf
#x [l] [xmin xmax] [xquant]     range of x, and logarithmic flag
#y [l] [xmin xmax] [yquant]     range of y, and logarithmic flag

#d "string"                     data string
#d0                             disable data string
#a [spacing] [initial]          automatic abscissas
#a0                             end auto abscissas

#m   integer    linestyle (0 unconnected; 1 solid; 2 dotted; etc )
#lw  number     line width
#alw number     axes linewidth
#g   integer    grid style (0 none; 1 ticks; 2 full; 3 half)

#nd  integer    number of divisions per large tick
#ndx integer    divisions per large tick on the x axis only
#ndy integer    divisions per large tick on the y axis only
#tks number     tick size (negative for ticks that stick out)
#tc             true clipping
#tc0            disable true clipping

#s ["string"]   new plot, same page
#n ["string"]   new plot, next page

#t              begin transposing x and y data
#t0             end   transposing data
#e              start plotting data with errors
#e0             end   plotting data with errors

#c "string"     default plot symbol
#c0             turn off default symbol
#cs number      plot symbol size

#lb             start break after labels
#lb0            end break after labels

#h number       fraction of height
#w number       fraction of width
#u number       fraction moved up
#r number       fraction moved right

#lt "string"    title
#lts number     title size
#ltx number     title x coordinate
#lty number     title y coordinate

#lx "string"    x axis label
#lxs number     x label size
#lxx number     x label x coordinate
#lxy number     x label y coordinate
#xf  "string"   x numbers printf format string

#ly  "string"   y axis label
#lyh "string"   y axis label written horizontally
#lys  number    y label size
#lyx  number    y label x coordinate
#lyy  number    y label y coordinate

#yf  "string"   y numbers printf format string

#lns number     label number size

#k ["string"]   command line comment

#i "filename"	include file

#ps             postscript output
#ug             unix-graphics output (default)
#xyil           output is an xyplot intermediate language

#scan "string"  output will be in format filtered by this program
                allowable outputs include "xyug" "cat" and "xyps"

#?              prints a version number and exits
                in the c-shell, type "xyplot -\?"
.fi


.SH "SEE ALSO"
.PD 0
.PP
.I "xyplot - a program for making two dimensional graphs",
.PP
.IR plot (1),
.IR tplot (1v),
.IR xyps (1L),
.IR xyug (1L),
.IR display (1L),
.IR sunplot (1L),
.IR xyview (1L)
.IR xyplay (1L)
.IR fig (1L).
.PD

.SH BUGS

The size of characters seen in the screen preview (eg, xyview, xyplay)
are not quite the same as those printed out in postscript.  Also,
the location of nonplotting characters is shifted slightly to the
right, which means for instance, that you cannot use "\\gd" as a
plotting symbol to get a triangle.

Please report bugs and suggestions for improvements or further features
to Ronnie Mainieri at ronnie@cardinal.lanl.gov or to
James Theiler at jt@t13.lanl.gov


