		/*  xyps - converts xylang into postscript */

#define YES	(1)
#define NO	(0)
#define MAXL	500	/* how many lineto before a stroke */
#define SCALE   0.123   /* scale factor in the post.ps prolog */
#define TX 	40.0	/* x translate in the post.ps prolog */
#define TY 	120.0	/* y translate in the post.ps prolog */
#include <stdio.h>
#include <math.h>
#include <time.h>
#include "patchlevel.h"

int printtimeQ = YES,
    printproQ = YES,
    optionproQ = NO,
    otherfontQ = NO,
    landscapeQ = NO,
    printheaderQ = NO,
    forceepsQ=YES,
    conformingQ = YES,
    erasures;

char *hstring,
     *font,
     *ProgName,
     *proname;

FILE *infile;


main(ac,av)
int ac;
char *av[];
{
	char *in,text[256],ftext[512],gstr[30],*date;
	char *getenv(),*nextline();
	int i,x,y,x1,x2,y1,y2,c;
	int nl,pmode,stroked,clearpage,pagenumber;
	int encapsulatedQ;
	float size;
	FILE *prolog, *fopen();
	struct { int llx,lly,urx,ury; } bbox;

	ProgName = av[0];
	infile=stdin;
	pagenumber = 0;
	if (ac!=1) readopts(ac,av);

	/* read the input and set flags for eps */
	getxyin(infile,&bbox);

	conformingQ = conformingQ && forceepsQ ;
	encapsulatedQ = conformingQ && (erasures == 1);
	/* print header junk */
	if (conformingQ) {
		if (encapsulatedQ)
			printf("%%!PS-Adobe-2.0 EPSF-2.0\n");
		else 
			printf("%%!PS-Adobe-2.0\n");
		printf("%%%%BoundingBox: ");
		printf("%-6d %-6d %-6d %-6d\n",
				 bbox.llx,bbox.lly,bbox.urx,bbox.ury);
		printf("%%%%Title: stdin\n");
		printf("%%%%Creator: %s\n",av[0]);
		maketimestr(&date);
		printf("%%%%CreationDate: %s\n",date);
		/* the next two have to be fixed */
		printf("%%%%DocumentFonts: Helvetica Symbol Courier\n");
		printf("%%%%DocumentProcSets: post 1.0 1\n");
		printf("%%%%EndComents\n");
	}

	/* print the prolog */
	if (printproQ) {
	    /* find out where to get the prolog from */
	    if (optionproQ || (proname=getenv("XYPRO"))!=NULL) {
		prolog=fopen(proname,"r");
	    } else if ( (prolog=fopen("post","r")) == NULL ) {
		prolog = fopen(LIBPRO,"r");
	    }
	    if(prolog==NULL) {
		fprintf(stderr,"%s: Prolog not found. Set XYPRO.\n",av[0]);
		exit(-1);
	    }

	    if(conformingQ) 
		printf("%%%%BeginProcSet: post 1.0 1\n");
	    /* copy it out */
	    while( (c=getc(prolog)) != EOF ) putc(c,stdout);
	    fclose(prolog);
	    if(conformingQ) 
		printf("%%%%EndProcSet\n");
	}
	if (conformingQ) {
		printf("%%%%EndProlog\n\n");
	}


	/* x and y have the current point inside the loop */
	i=0;pmode =NO; nl=0;stroked=NO;clearpage=YES;
	while((in=nextline())!=NULL) {	
		if (in[0] != 'p') pmode = NO;
		if(nl>=MAXL) {
			printf("%% A lot of lineto so lets \nstroke \n");
			printf("%6d %6d m\n",x,y);
			nl=0;stroked=YES;
		}
		if (clearpage) {
			++pagenumber;
			printf("%%%%Page: %d %d\n",pagenumber,pagenumber);
			if (landscapeQ) 
				printf("xydict begin\nlandstartup\n");
			else 
				printf("xydict begin\nstartup\n");
			if (printheaderQ) printheader();
			if (printtimeQ) printtime();
			if(otherfontQ) setotherfont();
			clearpage = NO;
		}

		switch (in[0]) {
		   case 'm' : 	sscanf(in,"%*s %d %d",&x,&y);
				printf("%6d %6d m\n",x,y);
				break;
		   case 'p' : 	sscanf(in,"%*s %d %d",&x,&y);
				if (!pmode) {
				   pmode = YES;
				   printf("spm\n");
			  	   printf("%6d %6d p\n",x,y);
				} else {
			  	   printf("%6d %6d p\n",x,y);
				}
				break;
		   case 'l' :	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				printf("%6d %6d %6d %6d l\n", x1,y1,x2,y2);
				++nl; stroked=NO;
				x=x1;y=y1;
				break;
		   case 'n' : 	sscanf(in,"%*s %d %d",&x,&y);
				printf("%6d %6d n\n",x,y);
				++nl; stroked=NO;
				break;
		   case 's' : 	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				break;
		   case 'b' : 	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				printf("%%%%BoundingBox: ");
				printf("%8.0f %8.0f %8.0f %8.0f\n",
				      TX,
				      TY,
				      x2*SCALE+TX,
				      y2*SCALE+TY
				);
				break;
		   case 't' :	sscanf(in,"%*s %s",text); 
				parse(ftext,text);
				printf("%s 1.0 %6d %6d t\n",x,y);
				break;
		   case 'f' :	sscanf(in,"%*s %s",text);
				nl=0;
				printf("stroke %s\n",text);
				stroked=YES;
				break;
		   case 'e' :	printf("e\n");
				printf("end %% the xydict\n");
				printf("%%%%PageTrailer\n\n");
				clearpage=YES;
				break;
		   case 'a' :	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				printf("%s %.3f %6d %6d a\n",ftext,size,x,y);
				break;
		   case 'r' : 	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				isreal(text);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				printf("%s %.3f %6d %6d r\n",ftext,size,x,y);
				break;
		   case 'i' :   sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				isreal(text);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				printf("%s %.3f %6d %6d c\n",ftext,size,x,y);
				break;
		   case 'c' :	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				isreal(text);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				printf("%s %.3f %6d %6d c\n",ftext,size,x,y);
				break;
		   case 'v' : 	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				printf("%s %.3f %6d %6d v\n",ftext,size,x,y);
				break;
		   case 'w' :   sscanf(in,"%*s %f",&size);
				printf("%6.3f w\n",size);
				break;
		   default  : 	fprintf(stderr,"Unexpexted command\n");
				exit(2);
				break;
		}
		i=0;
	}
	if (conformingQ)
		printf("%%%%Trailer\n");
}

printtime()
/* print the time the plot was translated to PostScript */
{
	static int sdQ = NO;
	char *at;

	if( !sdQ ) {
	   sdQ = YES;
	   printf("\n%% Print the time the plot was converted to PostScript\n");
	   maketimestr(&at);
	   printf("/date ( %s ) def\n",at);
	   printf("sdate\n");
	   printf("%% End of print time\n\n");
	} else {
	   printf("sdate\n");
	}
}

maketimestr(s)
char **s;
{
	long time(),timep;
	struct tm *localtime(),*t;
	char *asctime();

	time(&timep);  /* get system time */
	t = localtime(&timep);
	*s = asctime(t);
	(*s)[24]='\0';  /* get rid of the return */
}

printheader()
{
	static int sentheader = NO;

	if (!sentheader) {
		sentheader =YES;
		printf("%% Header for every page\n");
		printf("/header (%s) def\n",hstring);
		printf("sheader\n");
		printf("%% End of set header\n");
	} else {
		printf("sheader\n");
	}
}

setotherfont()
{
	printf("%% set fonts\n");
	if ( eq(font,"cb") ) {
		printf("/RomanFont /Courier-Bold def\n");
		printf("/dlinew 10 def\n");
	} else if ( eq(font,"co") ) {
		printf("/RomanFont /Courier def\n");
		printf("/dlinew 4 def\n");
	} else if ( eq(font,"ho") ) {
		printf("/RomanFont /Helvetica-Oblique def\n");
		printf("/slant 0.1667 def\n");
	} else if ( eq(font,"tr") ) {
		printf("/RomanFont /Times-Roman def\n");
	} else {
		fprintf(stderr,"Unknown font choice. Try cb co ho tr\n");
	}
	printf("%% end of font setup\n\n");
}

isreal(t)
char *t;
{
	char ms[30],es[6],c,*ti;
	int exp,expresent;
	double mant;

	expresent=NO;

	/* store initial string pointer */
	ti = t;

	/* almost parse a real number */

	/* leading space is okay */
	while( *t != '\0' && isspace(*t) ) ++t;   /* skip white space */

	/* leading character better be a digit, sign, or decimal point */
        if ( *t != '\0' && (isdigit(*t) || *t=='+' || *t=='-' || *t=='.') ) 
		++t;
	else
		return NO;

	while( *t != '\0' && isdigit(*t) ) ++t;
	while( *t != '\0' && ( *t=='.' ) ) ++t;
	while( *t != '\0' && isdigit(*t) ) ++t;

	/* saved what has been parsed */
	c=*t; *t='\0';
	strcpy(ms,ti);
	*t=c;

	/* check for exponent */
	if (*t=='e' || *t=='E' )
	{
		++t;
		/* first char after 'e' better be a digit or sign */
		if   ( *t == '\0' || !(isdigit(*t) || *t=='+' || *t=='-' ) ) 
			return NO;
		else
		{
			expresent = YES;
			strcpy(es,t);  /* save it */
			++t;
			while( *t != '\0' && isdigit(*t) ) ++t;
		}
	}
	
	/* trailing space is okay */
	while( *t != '\0' && isspace(*t) ) ++t; 

	/* if made it to the end then its a real */
	if (*t=='\0') {
		if (expresent) {
			sscanf(es,"%d",&exp);
			sprintf(es,"%-d",exp);
			sscanf(ms,"%lf",&mant);
			if (mant == 1.0 ) {
			  sprintf(ti,"10\\sp%s\\ep",es);
			} else {
			  sprintf(ti,"%s 10\\sp%s\\ep",ms,es);
			}
		}
		return(YES);
	} else {
		return(NO);
	}
}


readopts(ac,av)
int ac;
char *av[];
{
	int c;
	extern int optind;
	extern char *optarg;
	FILE *fopen();

	while( (c=getopt(ac,av,"?edclp:f:h:")) != EOF) {
	  switch (c) {
		case 'd' :  printtimeQ=NO;
			    break;
		case 'e' :  forceepsQ=NO;
			    break;
		case 'c' :  printproQ=NO;
			    break;
		case 'l' :  landscapeQ = YES;
			    break;
		case 'p' :  printproQ=YES; optionproQ=YES;
		            proname=optarg;
			    break;
		case 'f' :  otherfontQ=YES;
			    font=optarg;
			    break;
		case 'h' :  printheaderQ=YES;
			    hstring=optarg;
			    break;
		case '?' :  fprintf(stderr,"xyps 1.0 patchlevel %-d\n",PATCHED);
			    exit(1);
			    break;
		default :   fprintf(stderr,"Unknown option %c\n",c);
			    exit(-1);
			    break;
	  }
	}

	if (optind<ac) {
		infile=fopen(av[optind],"r");
		if (infile==NULL) {
			fprintf(stderr,"Cannot open %s\n",av[optind]);
			exit(-1);
		}
	} else  {
		infile = stdin;
	}
}

